/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.MatchType;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.spi.MemberFormatter;

public abstract class LevelBase
extends OlapElementBase
implements Level {
    protected final Hierarchy hierarchy;
    protected final String name;
    protected final String uniqueName;
    protected final String description;
    protected final int depth;
    protected final LevelType levelType;
    protected MemberFormatter memberFormatter;
    protected int approxRowCount;

    protected LevelBase(Hierarchy hierarchy, String name, String caption, boolean visible, String description, int depth, LevelType levelType) {
        this.hierarchy = hierarchy;
        this.name = name;
        this.caption = caption;
        this.visible = visible;
        this.description = description;
        this.uniqueName = Util.makeFqName(hierarchy, name);
        this.depth = depth;
        this.levelType = levelType;
    }

    public void setApproxRowCount(int approxRowCount) {
        this.approxRowCount = approxRowCount;
    }

    @Override
    public String getQualifiedName() {
        return MondrianResource.instance().MdxLevelName.str(this.getUniqueName());
    }

    @Override
    public LevelType getLevelType() {
        return this.levelType;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public Dimension getDimension() {
        return this.hierarchy.getDimension();
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public Level getChildLevel() {
        int childDepth = this.depth + 1;
        Level[] levels = this.hierarchy.getLevels();
        return childDepth < levels.length ? levels[childDepth] : null;
    }

    @Override
    public Level getParentLevel() {
        int parentDepth = this.depth - 1;
        Level[] levels = this.hierarchy.getLevels();
        return parentDepth >= 0 ? levels[parentDepth] : null;
    }

    @Override
    public abstract boolean isAll();

    public boolean isMeasure() {
        return this.hierarchy.getName().equals("Measures");
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        if (this.areMembersUnique() && s instanceof Id.NameSegment) {
            return Util.lookupHierarchyRootMember(schemaReader, this.hierarchy, (Id.NameSegment)s, matchType);
        }
        return null;
    }

    @Override
    public MemberFormatter getMemberFormatter() {
        return this.memberFormatter;
    }
}

