/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.MatchType;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class DimensionBase
extends OlapElementBase
implements Dimension {
    protected final String name;
    protected final String uniqueName;
    protected final String description;
    protected final boolean highCardinality;
    protected Hierarchy[] hierarchies;
    protected DimensionType dimensionType;

    protected DimensionBase(String name, String caption, boolean visible, String description, DimensionType dimensionType, boolean highCardinality) {
        this.name = name;
        this.caption = caption;
        this.visible = visible;
        this.uniqueName = Util.makeFqName(name);
        this.description = description;
        this.dimensionType = dimensionType;
        this.highCardinality = highCardinality;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Hierarchy[] getHierarchies() {
        return this.hierarchies;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.hierarchies[0];
    }

    @Override
    public Dimension getDimension() {
        return this;
    }

    @Override
    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public String getQualifiedName() {
        return MondrianResource.instance().MdxDimensionName.str(this.getUniqueName());
    }

    @Override
    public boolean isMeasures() {
        return this.getUniqueName().equals("[Measures]");
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        OlapElement oe = null;
        if (s instanceof Id.NameSegment) {
            oe = this.lookupHierarchy((Id.NameSegment)s);
        }
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            OlapElement oeLevel;
            if ((oe == null || oe.getName().equalsIgnoreCase(this.getName())) && (oeLevel = this.getHierarchy().lookupChild(schemaReader, s, matchType)) != null) {
                return oeLevel;
            }
            return oe;
        }
        if (oe != null) {
            return oe;
        }
        List<Hierarchy> hierarchyList = schemaReader.getDimensionHierarchies(this);
        for (Hierarchy hierarchy : hierarchyList) {
            oe = hierarchy.lookupChild(schemaReader, s, matchType);
            if (oe == null) continue;
            return oe;
        }
        return null;
    }

    @Override
    public boolean isHighCardinality() {
        return this.highCardinality;
    }

    private Hierarchy lookupHierarchy(Id.NameSegment s) {
        for (Hierarchy hierarchy : this.hierarchies) {
            if (!Util.equalName(hierarchy.getName(), s.getName())) continue;
            return hierarchy;
        }
        return null;
    }
}

