/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing.sequence;

import java.util.Collection;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.typing.Sequence;

public class RawArraySequence
implements Sequence {
    private Object[] array;
    private int counter;

    public RawArraySequence(Object[] array) {
        this.array = array;
        this.counter = 0;
    }

    public RawArraySequence(Collection array) {
        this.array = array.toArray();
        this.counter = 0;
    }

    @Override
    public boolean hasNext() throws EvaluationException {
        return this.counter < this.array.length;
    }

    @Override
    public Object next() throws EvaluationException {
        Object retval = this.array[this.counter];
        ++this.counter;
        return retval;
    }

    @Override
    public LValue nextRawValue() throws EvaluationException {
        Object retval = this.array[this.counter];
        ++this.counter;
        return new StaticValue(retval);
    }
}

