/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class StringCountFunction
implements Function {
    private static final long serialVersionUID = -1557813953499941337L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        Type searchTextType = parameters.getType(1);
        Object searchTextValue = parameters.getValue(1);
        String text = typeRegistry.convertToText(textType, textValue);
        String searchText = typeRegistry.convertToText(searchTextType, searchTextValue);
        if (searchText.length() == 0) {
            return new TypeValuePair(NumberType.GENERIC_NUMBER, 0);
        }
        int index = text.indexOf(searchText);
        if (index == -1) {
            return new TypeValuePair(NumberType.GENERIC_NUMBER, 0);
        }
        int occcounter = 0;
        while (index >= 0) {
            int oldIndex = index + searchText.length();
            index = text.indexOf(searchText, oldIndex);
            ++occcounter;
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, occcounter);
    }

    @Override
    public String getCanonicalName() {
        return "STRINGCOUNT";
    }
}

