/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WaitingImageObserver
implements ImageObserver {
    private static final Log LOGGER = LogFactory.getLog(WaitingImageObserver.class);
    private static final long serialVersionUID = -807204410581383550L;
    private boolean lock;
    private Image image;
    private boolean error;
    private long lastUpdate;
    private static final long MAX_LOADTIME_DEFAULT = 2000L;
    private long maxLoadTime;

    public WaitingImageObserver(Image image) {
        this(image, 2000L);
    }

    public WaitingImageObserver(Image image, long maxLoadTime) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
        this.lock = true;
        this.maxLoadTime = maxLoadTime;
    }

    @Override
    public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (img == null) {
            throw new NullPointerException();
        }
        this.lastUpdate = System.currentTimeMillis();
        if ((infoflags & 0x20) == 32) {
            this.lock = false;
            this.error = false;
            this.notifyAll();
            return false;
        }
        if ((infoflags & 0x10) == 16) {
            this.lock = false;
            this.error = false;
            this.notifyAll();
            return false;
        }
        if ((infoflags & 0x80) == 128 || (infoflags & 0x40) == 64) {
            this.lock = false;
            this.error = true;
            this.notifyAll();
            return false;
        }
        this.notifyAll();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitImageLoaded() {
        if (!this.lock) {
            return;
        }
        BufferedImage img = new BufferedImage(100, 100, 1);
        Graphics g = img.getGraphics();
        try {
            while (this.lock && !this.error) {
                this.lastUpdate = System.currentTimeMillis();
                if (g.drawImage(this.image, 0, 0, img.getWidth(this), img.getHeight(this), this)) {
                    return;
                }
                try {
                    this.wait(500L);
                }
                catch (InterruptedException e) {
                    LOGGER.info((Object)"WaitingImageObserver.waitImageLoaded(): InterruptedException thrown", (Throwable)e);
                }
                if (!this.lock) {
                    return;
                }
                if (this.maxLoadTime <= 0L || this.lastUpdate >= System.currentTimeMillis() - this.maxLoadTime) continue;
                this.error = true;
                this.lock = false;
                LOGGER.info((Object)"WaitingImageObserver.waitImageLoaded(): Image loading reached timeout.");
                return;
            }
        }
        finally {
            g.dispose();
        }
    }

    public boolean isLoadingComplete() {
        return !this.lock;
    }

    public boolean isError() {
        return this.error;
    }
}

