/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.config.metadata;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.config.metadata.ConfigurationDomain;
import org.pentaho.reporting.libraries.base.config.metadata.ConfigurationMetaData;
import org.pentaho.reporting.libraries.base.config.metadata.ConfigurationMetaDataEntry;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConfigurationMetaDataParser {
    private static Document parseInputStream(InputStream instream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.parse(new InputSource(instream));
    }

    public void parse(InputStream in, String domain) throws IOException {
        try {
            ConfigurationDomain d = ConfigurationMetaData.getInstance().createDomain(domain);
            Document doc = ConfigurationMetaDataParser.parseInputStream(in);
            Element documentElement = doc.getDocumentElement();
            NodeList keys = documentElement.getElementsByTagName("key");
            for (int i = 0; i < keys.getLength(); ++i) {
                ConfigurationMetaDataEntry entr = this.parseEntry((Element)keys.item(i));
                d.add(entr);
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    private ConfigurationMetaDataEntry parseEntry(Element item) throws IOException {
        String name = item.getAttribute("name");
        if (StringUtils.isEmpty(name)) {
            throw new IOException("Name for entry is null");
        }
        ConfigurationMetaDataEntry entry = new ConfigurationMetaDataEntry(name);
        entry.setDescription(this.getText(item, "description"));
        entry.setClassName(this.getClass(item));
        entry.setGlobal("true".equals(item.getAttribute("global")));
        entry.setHidden("true".equals(item.getAttribute("hidden")));
        this.parseEnum(item, entry);
        return entry;
    }

    private void parseEnum(Element item, ConfigurationMetaDataEntry entry) {
        NodeList nl = item.getElementsByTagName("enum");
        if (nl.getLength() > 0) {
            Element enumElement = (Element)nl.item(0);
            NodeList textNl = enumElement.getElementsByTagName("text");
            for (int i = 0; i < textNl.getLength(); ++i) {
                Element text = (Element)textNl.item(i);
                entry.addTag(text.getTextContent(), text.getTextContent());
            }
            NodeList entryNl = enumElement.getElementsByTagName("entry");
            for (int i = 0; i < entryNl.getLength(); ++i) {
                Element text = (Element)entryNl.item(i);
                entry.addTag(this.getText(text, "text"), this.getText(text, "display-name"));
            }
        }
    }

    private String getClass(Element base) {
        Element descElement;
        String attr;
        NodeList nl = base.getElementsByTagName("class");
        if (nl.getLength() > 0 && !StringUtils.isEmpty(attr = (descElement = (Element)nl.item(0)).getAttribute("instanceof"))) {
            return attr;
        }
        return null;
    }

    private String getText(Element base, String elementName) {
        NodeList nl = base.getElementsByTagName(elementName);
        if (nl.getLength() > 0) {
            Element descElement = (Element)nl.item(0);
            return descElement.getTextContent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseConfiguration(AbstractBoot boot) throws IOException {
        String domain = boot.getConfigurationDomain();
        Module[] activeModules = boot.getPackageManager().getActiveModules();
        for (int i = 0; i < activeModules.length; ++i) {
            Module activeModule = activeModules[i];
            InputStream resourceAsStream = activeModule.getClass().getResourceAsStream("config-description.xml");
            if (resourceAsStream == null) continue;
            try {
                this.parse(resourceAsStream, domain);
                continue;
            }
            finally {
                resourceAsStream.close();
            }
        }
    }
}

