/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.yamlinput;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.yamlinput.YamlInputData;
import org.pentaho.di.trans.steps.yamlinput.YamlInputField;
import org.pentaho.di.trans.steps.yamlinput.YamlInputMeta;
import org.pentaho.di.trans.steps.yamlinput.YamlReader;

public class YamlInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = YamlInputMeta.class;
    private YamlInputMeta meta;
    private YamlInputData data;

    public YamlInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private void handleMissingFiles() throws KettleException {
        List nonExistantFiles = this.data.files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredFilesTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredFiles", (String[])new String[]{message}));
            throw new KettleException(BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = this.data.files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredFilesTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredNotAccessibleFiles", (String[])new String[]{message}));
            throw new KettleException(BaseMessages.getString(PKG, (String)"YamlInput.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    private boolean readNextString() {
        try {
            this.data.readrow = this.getRow();
            if (this.data.readrow == null) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"YamlInput.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.data.totalPreviousFields = this.data.outputRowMeta.size();
                this.data.totalOutFields = this.data.totalPreviousFields + this.data.nrInputFields;
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (Const.isEmpty((String)this.meta.getYamlField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.NoField", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"YamlInput.Log.NoField", (String[])new String[0]));
                }
                this.data.indexOfYamlField = this.getInputRowMeta().indexOfValue(this.meta.getYamlField());
                if (this.data.indexOfYamlField < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.ErrorFindingField", (String[])new String[]{this.meta.getYamlField()}));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"YamlInput.Exception.CouldnotFindField", (String[])new String[]{this.meta.getYamlField()}));
                }
            }
            String Fieldvalue = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfYamlField);
            this.getLinesInput();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"YamlInput.Log.YAMLStream", (String[])new String[]{this.meta.getYamlField(), Fieldvalue}));
            }
            if (this.meta.getIsAFile()) {
                this.data.yaml = new YamlReader();
                this.data.yaml.loadFile(KettleVFS.getFileObject((String)Fieldvalue, (VariableSpace)this.getTransMeta()));
                this.addFileToResultFilesname(this.data.yaml.getFile());
            } else {
                this.data.yaml = new YamlReader();
                this.data.yaml.loadString(Fieldvalue);
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.UnexpectedError", (String[])new String[]{e.toString()}));
            this.stopAll();
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    private void addFileToResultFilesname(FileObject file) throws Exception {
        if (this.meta.addResultFile()) {
            ResultFile resultFile = new ResultFile(0, file, this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment(BaseMessages.getString(PKG, (String)"YamlInput.Log.FileAddedResult", (String[])new String[0]));
            this.addResultFile(resultFile);
        }
    }

    private boolean openNextFile() {
        try {
            if (this.data.filenr >= this.data.files.nrOfFiles()) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"YamlInput.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            this.data.file = this.data.files.getFile(this.data.filenr);
            ++this.data.filenr;
            if (this.meta.isIgnoreEmptyFile() && this.data.file.getContent().getSize() == 0L) {
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"YamlInput.Error.FileSizeZero", (Object[])new Object[]{this.data.file.getName()}));
                }
                this.openNextFile();
            } else {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"YamlInput.Log.OpeningFile", (String[])new String[]{this.data.file.toString()}));
                }
                this.data.yaml = new YamlReader();
                this.data.yaml.loadFile(this.data.file);
                this.addFileToResultFilesname(this.data.file);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"YamlInput.Log.FileOpened", (String[])new String[]{this.data.file.toString()}));
                }
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"YamlInput.Log.UnableToOpenFile", (String[])new String[]{"" + this.data.filenr, this.data.file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            this.logError(Const.getStackTracker((Throwable)e));
            return false;
        }
        return true;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r;
        if (this.first && !this.meta.isInFields()) {
            this.first = false;
            this.data.files = this.meta.getFiles(this);
            if (!this.meta.isdoNotFailIfNoFile() && this.data.files.nrOfFiles() == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"YamlInput.Log.NoFiles", (String[])new String[0]));
            }
            this.handleMissingFiles();
            this.data.outputRowMeta = new RowMeta();
            this.data.totalPreviousFields = 0;
            this.data.totalOutFields = this.data.totalPreviousFields + this.data.nrInputFields;
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.totalOutStreamFields = this.data.outputRowMeta.size();
        }
        if ((r = this.getOneRow()) == null) {
            this.setOutputDone();
            return false;
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"YamlInput.Log.ReadRow", (String[])new String[]{this.data.outputRowMeta.getString(r)}));
        }
        this.incrementLinesOutput();
        ++this.data.rownr;
        this.putRow(this.data.outputRowMeta, r);
        if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private Object[] getOneRow() throws KettleException {
        Object[] row = null;
        boolean rowAvailable = false;
        boolean fileOpened = false;
        if (!this.meta.isInFields()) {
            while (this.data.file == null || this.data.file != null && !fileOpened && !rowAvailable) {
                if (this.data.file != null) {
                    row = this.getRowData();
                    if (row == null) {
                        if (!this.openNextFile()) {
                            return null;
                        }
                        fileOpened = true;
                        continue;
                    }
                    rowAvailable = true;
                    continue;
                }
                if (!this.openNextFile()) {
                    return null;
                }
                fileOpened = true;
            }
        } else {
            while (this.data.readrow == null || this.data.readrow != null && !fileOpened && !rowAvailable) {
                if (this.data.readrow != null) {
                    row = this.getRowData();
                    if (row == null) {
                        if (!this.readNextString()) {
                            return null;
                        }
                        fileOpened = true;
                    } else {
                        rowAvailable = true;
                    }
                } else {
                    if (!this.readNextString()) {
                        return null;
                    }
                    fileOpened = true;
                }
                if (this.data.readrow != null) continue;
                return null;
            }
        }
        if (!rowAvailable) {
            row = this.getRowData();
        }
        return row;
    }

    private Object[] getRowData() throws KettleException {
        Object[] outputRowData;
        block7: {
            outputRowData = null;
            try {
                outputRowData = this.data.yaml.getRow(this.data.rowMeta);
                if (outputRowData == null) {
                    return null;
                }
                outputRowData = this.data.readrow != null ? RowDataUtil.addRowData((Object[])this.data.readrow, (int)this.data.totalPreviousFields, (Object[])outputRowData) : RowDataUtil.resizeArray((Object[])outputRowData, (int)this.data.totalOutStreamFields);
                int rowIndex = this.data.totalOutFields;
                if (this.meta.includeFilename() && !Const.isEmpty((String)this.meta.getFilenameField())) {
                    outputRowData[rowIndex++] = KettleVFS.getFilename((FileObject)this.data.file);
                }
                if (this.meta.includeRowNumber() && !Const.isEmpty((String)this.meta.getRowNumberField())) {
                    outputRowData[rowIndex++] = new Long(this.data.rownr);
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (this.getStepMeta().isDoingErrorHandling()) {
                    sendToErrorRow = true;
                    errorMessage = e.toString();
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"YamlInput.ErrorInStepRunning", (String[])new String[]{e.toString()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.setOutputDone();
                }
                if (!sendToErrorRow) break block7;
                this.putError(this.getInputRowMeta(), outputRowData, 1L, errorMessage, null, "YamlInput001");
            }
        }
        return outputRowData;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (YamlInputMeta)smi;
        this.data = (YamlInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.rownr = 1L;
            this.data.nrInputFields = this.meta.getInputFields().length;
            this.data.rowMeta = new RowMeta();
            for (int i = 0; i < this.data.nrInputFields; ++i) {
                YamlInputField field = this.meta.getInputFields()[i];
                String path = this.environmentSubstitute(field.getPath());
                try {
                    ValueMetaInterface valueMeta = ValueMetaFactory.createValueMeta((String)path, (int)field.getType());
                    valueMeta.setTrimType(field.getTrimType());
                    this.data.rowMeta.addValueMeta(valueMeta);
                    continue;
                }
                catch (Exception e) {
                    this.log.logError("Unable to create value meta", (Throwable)e);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (YamlInputMeta)smi;
        this.data = (YamlInputData)sdi;
        if (this.data.yaml != null) {
            try {
                this.data.yaml.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.data.file != null) {
            try {
                this.data.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }
}

