/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileoutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMetaInjection;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class TextFileOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = TextFileOutputMeta.class;
    protected static final int FILE_COMPRESSION_TYPE_NONE = 0;
    protected static final int FILE_COMPRESSION_TYPE_ZIP = 1;
    protected static final String[] fileCompressionTypeCodes = new String[]{"None", "Zip"};
    public static final String[] formatMapperLineTerminator = new String[]{"DOS", "UNIX", "CR", "None"};
    private String fileName;
    private boolean fileAsCommand;
    private boolean servletOutput;
    private boolean createparentfolder = true;
    private String extension;
    private String separator;
    private String enclosure;
    private boolean enclosureForced;
    private boolean disableEnclosureFix;
    private boolean headerEnabled;
    private boolean footerEnabled;
    private String fileFormat;
    private String fileCompression;
    private int splitEvery;
    private boolean fileAppended;
    private boolean stepNrInFilename;
    private boolean partNrInFilename;
    private boolean dateInFilename;
    private boolean timeInFilename;
    private boolean padded;
    private boolean fastDump;
    private TextFileField[] outputFields;
    private String encoding;
    private String endedLine;
    private boolean fileNameInField;
    private String fileNameField;
    private String newline;
    private boolean addToResultFilenames;
    private boolean doNotOpenNewFileInit;
    private boolean specifyingFormat;
    private String dateTimeFormat;

    public boolean isFileAsCommand() {
        return this.fileAsCommand;
    }

    public void setFileAsCommand(boolean fileAsCommand) {
        this.fileAsCommand = fileAsCommand;
    }

    public boolean isServletOutput() {
        return this.servletOutput;
    }

    public void setServletOutput(boolean servletOutput) {
        this.servletOutput = servletOutput;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public boolean isEnclosureForced() {
        return this.enclosureForced;
    }

    public void setEnclosureForced(boolean enclosureForced) {
        this.enclosureForced = enclosureForced;
    }

    public boolean isEnclosureFixDisabled() {
        return this.disableEnclosureFix;
    }

    public void setEnclosureFixDisabled(boolean disableEnclosureFix) {
        this.disableEnclosureFix = disableEnclosureFix;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isAddToResultFiles() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFiles(boolean addtoresultfilenamesin) {
        this.addToResultFilenames = addtoresultfilenamesin;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getFileCompression() {
        return this.fileCompression;
    }

    public void setFileCompression(String fileCompression) {
        this.fileCompression = fileCompression;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isFooterEnabled() {
        return this.footerEnabled;
    }

    public void setFooterEnabled(boolean footer) {
        this.footerEnabled = footer;
    }

    public boolean isHeaderEnabled() {
        return this.headerEnabled;
    }

    public void setHeaderEnabled(boolean header) {
        this.headerEnabled = header;
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public boolean isPadded() {
        return this.padded;
    }

    public void setPadded(boolean padded) {
        this.padded = padded;
    }

    public boolean isFastDump() {
        return this.fastDump;
    }

    public void setFastDump(boolean fastDump) {
        this.fastDump = fastDump;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    public int getSplitEvery() {
        return this.splitEvery;
    }

    public int getFooterShift() {
        return this.isFooterEnabled() ? 1 : 0;
    }

    public void setSplitEvery(int splitEvery) {
        this.splitEvery = splitEvery;
    }

    public boolean isStepNrInFilename() {
        return this.stepNrInFilename;
    }

    public void setStepNrInFilename(boolean stepNrInFilename) {
        this.stepNrInFilename = stepNrInFilename;
    }

    public boolean isPartNrInFilename() {
        return this.partNrInFilename;
    }

    public void setPartNrInFilename(boolean partNrInFilename) {
        this.partNrInFilename = partNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public boolean isSpecifyingFormat() {
        return this.specifyingFormat;
    }

    public void setSpecifyingFormat(boolean specifyingFormat) {
        this.specifyingFormat = specifyingFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public TextFileField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(TextFileField[] outputFields) {
        this.outputFields = outputFields;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEndedLine() {
        return this.endedLine;
    }

    public void setEndedLine(String endedLine) {
        this.endedLine = endedLine;
    }

    public boolean isFileNameInField() {
        return this.fileNameInField;
    }

    public void setFileNameInField(boolean fileNameInField) {
        this.fileNameInField = fileNameInField;
    }

    public String getFileNameField() {
        return this.fileNameField;
    }

    public void setFileNameField(String fileNameField) {
        this.fileNameField = fileNameField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, metaStore);
    }

    public void allocate(int nrfields) {
        this.outputFields = new TextFileField[nrfields];
    }

    @Override
    public Object clone() {
        TextFileOutputMeta retval = (TextFileOutputMeta)super.clone();
        int nrfields = this.outputFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.outputFields[i] = (TextFileField)this.outputFields[i].clone();
        }
        return retval;
    }

    private void readData(Node stepnode, IMetaStore metastore) throws KettleXMLException {
        try {
            this.separator = XMLHandler.getTagValue((Node)stepnode, (String)"separator");
            if (this.separator == null) {
                this.separator = "";
            }
            this.enclosure = XMLHandler.getTagValue((Node)stepnode, (String)"enclosure");
            if (this.enclosure == null) {
                this.enclosure = "";
            }
            this.enclosureForced = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"enclosure_forced"));
            String sDisableEnclosureFix = XMLHandler.getTagValue((Node)stepnode, (String)"enclosure_fix_disabled");
            this.disableEnclosureFix = sDisableEnclosureFix == null ? true : "Y".equalsIgnoreCase(sDisableEnclosureFix);
            String createParentFolderTagValue = XMLHandler.getTagValue((Node)stepnode, (String)"create_parent_folder");
            this.createparentfolder = createParentFolderTagValue == null ? true : "Y".equalsIgnoreCase(createParentFolderTagValue);
            this.headerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"header"));
            this.footerEnabled = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"footer"));
            this.fileFormat = XMLHandler.getTagValue((Node)stepnode, (String)"format");
            this.fileCompression = XMLHandler.getTagValue((Node)stepnode, (String)"compression");
            if (this.fileCompression == null) {
                this.fileCompression = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"zipped")) ? fileCompressionTypeCodes[1] : fileCompressionTypeCodes[0];
            }
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.endedLine = XMLHandler.getTagValue((Node)stepnode, (String)"endedLine");
            if (this.endedLine == null) {
                this.endedLine = "";
            }
            this.fileName = this.loadSource(stepnode, metastore);
            this.fileAsCommand = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"is_command"));
            this.servletOutput = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"servlet_output"));
            this.doNotOpenNewFileInit = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"do_not_open_new_file_init"));
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"extention");
            this.fileAppended = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"append"));
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"split"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_time"));
            this.specifyingFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"SpecifyFormat"));
            this.dateTimeFormat = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"date_time_format");
            String AddToResultFiles = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_to_result_filenames");
            this.addToResultFilenames = Const.isEmpty((String)AddToResultFiles) ? true : "Y".equalsIgnoreCase(AddToResultFiles);
            this.padded = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"pad"));
            this.fastDump = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"fast_dump"));
            this.splitEvery = Const.toInt((String)XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"splitevery"), (int)0);
            this.newline = this.getNewLine(this.fileFormat);
            this.fileNameInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"fileNameInField"));
            this.fileNameField = XMLHandler.getTagValue((Node)stepnode, (String)"fileNameField");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.outputFields[i] = new TextFileField();
                this.outputFields[i].setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.outputFields[i].setType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                this.outputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.outputFields[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                this.outputFields[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.outputFields[i].setGroupingSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
                this.outputFields[i].setTrimType(ValueMeta.getTrimTypeByCode((String)XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
                this.outputFields[i].setNullString(XMLHandler.getTagValue((Node)fnode, (String)"nullif"));
                this.outputFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.outputFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void readData(Node stepnode) throws KettleXMLException {
        this.readData(stepnode, null);
    }

    public String getNewLine(String fformat) {
        String nl = System.getProperty("line.separator");
        if (fformat != null) {
            if (fformat.equalsIgnoreCase("DOS")) {
                nl = "\r\n";
            } else if (fformat.equalsIgnoreCase("UNIX")) {
                nl = "\n";
            } else if (fformat.equalsIgnoreCase("CR")) {
                nl = "\r";
            } else if (fformat.equalsIgnoreCase("None")) {
                nl = "";
            }
        }
        return nl;
    }

    @Override
    public void setDefault() {
        this.createparentfolder = true;
        this.separator = ";";
        this.enclosure = "\"";
        this.specifyingFormat = false;
        this.dateTimeFormat = null;
        this.enclosureForced = false;
        this.disableEnclosureFix = false;
        this.headerEnabled = true;
        this.footerEnabled = false;
        this.fileFormat = "DOS";
        this.fileCompression = fileCompressionTypeCodes[0];
        this.fileName = "file";
        this.fileAsCommand = false;
        this.servletOutput = false;
        this.doNotOpenNewFileInit = false;
        this.extension = "txt";
        this.stepNrInFilename = false;
        this.partNrInFilename = false;
        this.dateInFilename = false;
        this.timeInFilename = false;
        this.padded = false;
        this.fastDump = false;
        this.addToResultFilenames = true;
        this.splitEvery = 0;
        this.newline = this.getNewLine(this.fileFormat);
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.outputFields[i] = new TextFileField();
            this.outputFields[i].setName("field" + i);
            this.outputFields[i].setType("Number");
            this.outputFields[i].setFormat(" 0,000,000.00;-0,000,000.00");
            this.outputFields[i].setCurrencySymbol("");
            this.outputFields[i].setDecimalSymbol(",");
            this.outputFields[i].setGroupingSymbol(".");
            this.outputFields[i].setNullString("");
            this.outputFields[i].setLength(-1);
            this.outputFields[i].setPrecision(-1);
        }
        this.fileAppended = false;
    }

    public String[] getFiles(VariableSpace space) {
        int nr;
        int copies = 1;
        int splits = 1;
        int parts = 1;
        if (this.stepNrInFilename) {
            copies = 3;
        }
        if (this.partNrInFilename) {
            parts = 3;
        }
        if (this.splitEvery != 0) {
            splits = 3;
        }
        if ((nr = copies * parts * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int part = 0; part < parts; ++part) {
                for (int split = 0; split < splits; ++split) {
                    retval[i] = this.buildFilename(space, copy, "P" + part, split, false);
                    ++i;
                }
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(VariableSpace space, int stepnr, String partnr, int splitnr, boolean ziparchive) {
        return this.buildFilename(this.fileName, this.extension, space, stepnr, partnr, splitnr, ziparchive, this);
    }

    public String buildFilename(String filename, String extension, VariableSpace space, int stepnr, String partnr, int splitnr, boolean ziparchive, TextFileOutputMeta meta) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = space.environmentSubstitute(filename);
        String realextension = space.environmentSubstitute(extension);
        if (meta.isFileAsCommand()) {
            return retval;
        }
        Date now = new Date();
        if (meta.isSpecifyingFormat() && !Const.isEmpty((String)meta.getDateTimeFormat())) {
            daf.applyPattern(meta.getDateTimeFormat());
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (meta.isDateInFilename()) {
                daf.applyPattern("yyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (meta.isTimeInFilename()) {
                daf.applyPattern("HHmmss");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        if (meta.isStepNrInFilename()) {
            retval = retval + "_" + stepnr;
        }
        if (meta.isPartNrInFilename()) {
            retval = retval + "_" + partnr;
        }
        if (meta.getSplitEvery() > 0) {
            retval = retval + "_" + splitnr;
        }
        if (meta.getFileCompression().equals("Zip")) {
            if (ziparchive) {
                retval = retval + ".zip";
            } else if (realextension != null && realextension.length() != 0) {
                retval = retval + "." + realextension;
            }
        } else {
            if (realextension != null && realextension.length() != 0) {
                retval = retval + "." + realextension;
            }
            if (meta.getFileCompression().equals("GZip")) {
                retval = retval + ".gz";
            }
        }
        return retval;
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.outputFields.length; ++i) {
            TextFileField field = this.outputFields[i];
            ValueMetaInterface v = row.searchValueMeta(field.getName());
            if (v == null) continue;
            v.setLength(field.getLength());
            v.setPrecision(field.getPrecision());
            v.setConversionMask(field.getFormat());
            v.setDecimalSymbol(field.getDecimalSymbol());
            v.setGroupingSymbol(field.getGroupingSymbol());
            v.setCurrencySymbol(field.getCurrencySymbol());
            v.setOutputPaddingEnabled(this.isPadded());
            v.setTrimType(field.getTrimType());
            if (!Const.isEmpty((String)this.getEncoding())) {
                v.setStringEncoding(this.getEncoding());
            }
            v.setOutputPaddingEnabled(true);
        }
    }

    @Override
    @Deprecated
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        this.getFields(inputRowMeta, name, info, nextStep, space, null, null);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(800);
        retval.append("    ").append(XMLHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclosure", (String)this.enclosure));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclosure_forced", (boolean)this.enclosureForced));
        retval.append("    ").append(XMLHandler.addTagValue((String)"enclosure_fix_disabled", (boolean)this.disableEnclosureFix));
        retval.append("    ").append(XMLHandler.addTagValue((String)"header", (boolean)this.headerEnabled));
        retval.append("    ").append(XMLHandler.addTagValue((String)"footer", (boolean)this.footerEnabled));
        retval.append("    ").append(XMLHandler.addTagValue((String)"format", (String)this.fileFormat));
        retval.append("    ").append(XMLHandler.addTagValue((String)"compression", (String)this.fileCompression));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"endedLine", (String)this.endedLine));
        retval.append("    " + XMLHandler.addTagValue((String)"fileNameInField", (boolean)this.fileNameInField));
        retval.append("    " + XMLHandler.addTagValue((String)"fileNameField", (String)this.fileNameField));
        retval.append("    " + XMLHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append("    <file>").append(Const.CR);
        this.saveSource(retval, this.fileName);
        retval.append("      ").append(XMLHandler.addTagValue((String)"is_command", (boolean)this.fileAsCommand));
        retval.append("      ").append(XMLHandler.addTagValue((String)"servlet_output", (boolean)this.servletOutput));
        retval.append("      ").append(XMLHandler.addTagValue((String)"do_not_open_new_file_init", (boolean)this.doNotOpenNewFileInit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"append", (boolean)this.fileAppended));
        retval.append("      ").append(XMLHandler.addTagValue((String)"split", (boolean)this.stepNrInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.specifyingFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.dateTimeFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_to_result_filenames", (boolean)this.addToResultFilenames));
        retval.append("      ").append(XMLHandler.addTagValue((String)"pad", (boolean)this.padded));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fast_dump", (boolean)this.fastDump));
        retval.append("      ").append(XMLHandler.addTagValue((String)"splitevery", (int)this.splitEvery));
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            TextFileField field = this.outputFields[i];
            if (field.getName() == null || field.getName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)field.getGroupingSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trim_type", (String)field.getTrimTypeCode()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.separator = rep.getStepAttributeString(id_step, "separator");
            this.enclosure = rep.getStepAttributeString(id_step, "enclosure");
            this.enclosureForced = rep.getStepAttributeBoolean(id_step, "enclosure_forced");
            this.disableEnclosureFix = rep.getStepAttributeBoolean(id_step, 0, "enclosure_fix_disabled", true);
            this.createparentfolder = rep.getStepAttributeBoolean(id_step, "create_parent_folder");
            this.headerEnabled = rep.getStepAttributeBoolean(id_step, "header");
            this.footerEnabled = rep.getStepAttributeBoolean(id_step, "footer");
            this.fileFormat = rep.getStepAttributeString(id_step, "format");
            this.fileCompression = rep.getStepAttributeString(id_step, "compression");
            this.fileNameInField = rep.getStepAttributeBoolean(id_step, "fileNameInField");
            this.fileNameField = rep.getStepAttributeString(id_step, "fileNameField");
            if (this.fileCompression == null) {
                this.fileCompression = rep.getStepAttributeBoolean(id_step, "zipped") ? fileCompressionTypeCodes[1] : fileCompressionTypeCodes[0];
            }
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.fileName = this.loadSourceRep(rep, id_step);
            this.fileAsCommand = rep.getStepAttributeBoolean(id_step, "file_is_command");
            this.servletOutput = rep.getStepAttributeBoolean(id_step, "file_servlet_output");
            this.doNotOpenNewFileInit = rep.getStepAttributeBoolean(id_step, "do_not_open_new_file_init");
            this.extension = rep.getStepAttributeString(id_step, "file_extention");
            this.fileAppended = rep.getStepAttributeBoolean(id_step, "file_append");
            this.splitEvery = (int)rep.getStepAttributeInteger(id_step, "file_split");
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_stepnr");
            this.partNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_partnr");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "file_add_date");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "file_add_time");
            this.specifyingFormat = rep.getStepAttributeBoolean(id_step, "SpecifyFormat");
            this.dateTimeFormat = rep.getStepAttributeString(id_step, "date_time_format");
            String AddToResultFiles = rep.getStepAttributeString(id_step, "add_to_result_filenames");
            this.addToResultFilenames = Const.isEmpty((String)AddToResultFiles) ? true : rep.getStepAttributeBoolean(id_step, "add_to_result_filenames");
            this.padded = rep.getStepAttributeBoolean(id_step, "file_pad");
            this.fastDump = rep.getStepAttributeBoolean(id_step, "file_fast_dump");
            this.newline = this.getNewLine(this.fileFormat);
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.outputFields[i] = new TextFileField();
                this.outputFields[i].setName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.outputFields[i].setType(rep.getStepAttributeString(id_step, i, "field_type"));
                this.outputFields[i].setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                this.outputFields[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                this.outputFields[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                this.outputFields[i].setGroupingSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                this.outputFields[i].setTrimType(ValueMeta.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trim_type")));
                this.outputFields[i].setNullString(rep.getStepAttributeString(id_step, i, "field_nullif"));
                this.outputFields[i].setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                this.outputFields[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
            }
            this.endedLine = rep.getStepAttributeString(id_step, "endedLine");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "separator", this.separator);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure", this.enclosure);
            rep.saveStepAttribute(id_transformation, id_step, "enclosure_forced", this.enclosureForced);
            rep.saveStepAttribute(id_transformation, id_step, 0, "enclosure_fix_disabled", this.disableEnclosureFix);
            rep.saveStepAttribute(id_transformation, id_step, "header", this.headerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "footer", this.footerEnabled);
            rep.saveStepAttribute(id_transformation, id_step, "format", this.fileFormat);
            rep.saveStepAttribute(id_transformation, id_step, "compression", this.fileCompression);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            this.saveSourceRep(rep, id_transformation, id_step, this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "file_is_command", this.fileAsCommand);
            rep.saveStepAttribute(id_transformation, id_step, "file_servlet_output", this.servletOutput);
            rep.saveStepAttribute(id_transformation, id_step, "do_not_open_new_file_init", this.doNotOpenNewFileInit);
            rep.saveStepAttribute(id_transformation, id_step, "file_extention", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "file_append", this.fileAppended);
            rep.saveStepAttribute(id_transformation, id_step, "file_split", this.splitEvery);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_stepnr", this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_partnr", this.partNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_date", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "date_time_format", this.dateTimeFormat);
            rep.saveStepAttribute(id_transformation, id_step, "create_parent_folder", this.createparentfolder);
            rep.saveStepAttribute(id_transformation, id_step, "SpecifyFormat", this.specifyingFormat);
            rep.saveStepAttribute(id_transformation, id_step, "add_to_result_filenames", this.addToResultFilenames);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_time", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_pad", this.padded);
            rep.saveStepAttribute(id_transformation, id_step, "file_fast_dump", this.fastDump);
            rep.saveStepAttribute(id_transformation, id_step, "fileNameInField", this.fileNameInField);
            rep.saveStepAttribute(id_transformation, id_step, "fileNameField", this.fileNameField);
            for (int i = 0; i < this.outputFields.length; ++i) {
                TextFileField field = this.outputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupingSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_nullif", field.getNullString());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
            }
            rep.saveStepAttribute(id_transformation, id_step, "endedLine", this.endedLine);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.indexOfValue(this.outputFields[i].getName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.outputFields[i].getName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"TextFileOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new TextFileOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new TextFileOutputData();
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository, IMetaStore metaStore) throws KettleException {
        try {
            if (!this.fileNameInField && !Const.isEmpty((String)this.fileName)) {
                FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName), (VariableSpace)space);
                this.fileName = resourceNamingInterface.nameResource(fileObject, space, true);
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void setFilename(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return new TextFileOutputMetaInjection(this);
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return this.getStepMetaInjectionInterface().extractStepMetadataEntries();
    }

    protected String loadSource(Node stepnode, IMetaStore metastore) {
        return XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
    }

    protected void saveSource(StringBuffer retVal, String value) {
        retVal.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName));
    }

    protected String loadSourceRep(Repository rep, ObjectId id_step) throws KettleException {
        return rep.getStepAttributeString(id_step, "file_name");
    }

    protected void saveSourceRep(Repository rep, ObjectId id_transformation, ObjectId id_step, String value) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "file_name", this.fileName);
    }
}

