/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableinput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInjectionUtil;
import org.pentaho.di.trans.step.StepMetaInjectionEntryInterface;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;

public class TableInputMetaInjection
implements StepMetaInjectionInterface {
    private TableInputMeta meta;

    public TableInputMetaInjection(TableInputMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        Entry[] topEntries;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        for (Entry topEntry : topEntries = new Entry[]{Entry.SQL, Entry.LAZY_CONVERSION, Entry.REPLACE_VARIABLES, Entry.EXECUTE_FOR_EACH_ROW, Entry.LIMIT}) {
            all.add(new StepInjectionMetaEntry(topEntry.name(), topEntry.getValueType(), topEntry.getDescription()));
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case SQL: {
                    this.meta.setSQL(lookValue);
                    break;
                }
                case LAZY_CONVERSION: {
                    this.meta.setLazyConversionActive("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case REPLACE_VARIABLES: {
                    this.meta.setVariableReplacementActive("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case EXECUTE_FOR_EACH_ROW: {
                    this.meta.setExecuteEachInputRow("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case LIMIT: {
                    this.meta.setRowLimit(lookValue);
                    break;
                }
            }
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        ArrayList<StepInjectionMetaEntry> list = new ArrayList<StepInjectionMetaEntry>();
        list.add(StepInjectionUtil.getEntry(Entry.SQL, this.meta.getSQL()));
        list.add(StepInjectionUtil.getEntry(Entry.LAZY_CONVERSION, this.meta.isLazyConversionActive()));
        list.add(StepInjectionUtil.getEntry(Entry.REPLACE_VARIABLES, this.meta.isVariableReplacementActive()));
        list.add(StepInjectionUtil.getEntry(Entry.EXECUTE_FOR_EACH_ROW, this.meta.isExecuteEachInputRow()));
        list.add(StepInjectionUtil.getEntry(Entry.LIMIT, this.meta.getRowLimit()));
        return list;
    }

    public TableInputMeta getMeta() {
        return this.meta;
    }

    public static enum Entry implements StepMetaInjectionEntryInterface
    {
        SQL(2, "The SQL for the table input step"),
        LAZY_CONVERSION(2, "Enable lazy conversion? (Y/N)"),
        REPLACE_VARIABLES(2, "Replace variables in script? (Y/N)"),
        EXECUTE_FOR_EACH_ROW(2, "Execute for each row?? (Y/N)"),
        LIMIT(2, "Limit size");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        @Override
        public int getValueType() {
            return this.valueType;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

