/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.splitfieldtorows;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.splitfieldtorows.SplitFieldToRowsData;
import org.pentaho.di.trans.steps.splitfieldtorows.SplitFieldToRowsMeta;

public class SplitFieldToRows
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = SplitFieldToRowsMeta.class;
    private SplitFieldToRowsMeta meta;
    private SplitFieldToRowsData data;

    public SplitFieldToRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private boolean splitField(RowMetaInterface rowMeta, Object[] rowData) throws KettleException {
        String[] splitStrings;
        String originalString;
        if (this.first) {
            String realRowNumberField;
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            String realSplitFieldName = this.environmentSubstitute(this.meta.getSplitField());
            this.data.fieldnr = rowMeta.indexOfValue(realSplitFieldName);
            int numErrors = 0;
            if (Const.isEmpty((String)this.meta.getNewFieldname())) {
                this.logError(BaseMessages.getString(PKG, (String)"SplitFieldToRows.Log.NewFieldNameIsNull", (String[])new String[0]));
                ++numErrors;
            }
            if (this.data.fieldnr < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"SplitFieldToRows.Log.CouldNotFindFieldToSplit", (String[])new String[]{realSplitFieldName}));
                ++numErrors;
            }
            if (!rowMeta.getValueMeta(this.data.fieldnr).isString()) {
                this.logError(BaseMessages.getString(PKG, (String)"SplitFieldToRows.Log.SplitFieldNotValid", (String[])new String[]{realSplitFieldName}));
                ++numErrors;
            }
            if (this.meta.includeRowNumber() && Const.isEmpty((String)(realRowNumberField = this.environmentSubstitute(this.meta.getRowNumberField())))) {
                this.logError(BaseMessages.getString(PKG, (String)"SplitFieldToRows.Exception.RownrFieldMissing", (String[])new String[0]));
                ++numErrors;
            }
            if (numErrors > 0) {
                this.setErrors(numErrors);
                this.stopAll();
                return false;
            }
            this.data.splitMeta = rowMeta.getValueMeta(this.data.fieldnr);
        }
        if ((originalString = this.data.splitMeta.getString(rowData[this.data.fieldnr])) == null) {
            originalString = "";
        }
        if (this.meta.includeRowNumber() && this.meta.resetRowNumber()) {
            this.data.rownr = 1L;
        }
        for (String string : splitStrings = this.data.delimiterPattern.split(originalString, -1)) {
            Object[] outputRow = RowDataUtil.createResizedCopy((Object[])rowData, (int)this.data.outputRowMeta.size());
            outputRow[rowMeta.size()] = string;
            if (this.meta.includeRowNumber()) {
                outputRow[rowMeta.size() + 1] = this.data.rownr;
            }
            this.putRow(this.data.outputRowMeta, outputRow);
            ++this.data.rownr;
        }
        return true;
    }

    @Override
    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SplitFieldToRowsMeta)smi;
        this.data = (SplitFieldToRowsData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        boolean ok = this.splitField(this.getInputRowMeta(), r);
        if (!ok) {
            this.setOutputDone();
            return false;
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed() && this.log.isDetailed()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"SplitFieldToRows.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SplitFieldToRowsMeta)smi;
        this.data = (SplitFieldToRowsData)sdi;
        if (super.init(smi, sdi)) {
            this.data.rownr = 1L;
            try {
                this.data.delimiterPattern = this.meta.isDelimiterRegex() ? Pattern.compile(this.environmentSubstitute(this.meta.getDelimiter())) : Pattern.compile(Pattern.quote(this.environmentSubstitute(this.meta.getDelimiter())));
            }
            catch (PatternSyntaxException pse) {
                this.log.logError(pse.getMessage());
                throw pse;
            }
            return true;
        }
        return false;
    }
}

