/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rssoutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rssoutput.RssOutput;
import org.pentaho.di.trans.steps.rssoutput.RssOutputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class RssOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = RssOutput.class;
    private String channeltitle;
    private String channeldescription;
    private String channellink;
    private String channelpubdate;
    private String channelcopyright;
    private String channelimagetitle;
    private String channelimagelink;
    private String channelimageurl;
    private String channelimagedescription;
    private String channellanguage;
    private String channelauthor;
    private String itemtitle;
    private String itemdescription;
    private String itemlink;
    private String itempubdate;
    private String itemauthor;
    private String geopointlat;
    private String geopointlong;
    private boolean AddToResult;
    private String fileName;
    private String extension;
    private boolean stepNrInFilename;
    private boolean partNrInFilename;
    private boolean dateInFilename;
    private boolean timeInFilename;
    private boolean createparentfolder;
    private String version;
    private String encoding;
    private boolean addimage;
    private boolean addgeorss;
    private boolean usegeorssgml;
    private String filenamefield;
    private boolean isfilenameinfield;
    private String[] ChannelCustomFields;
    private String[] NameSpaces;
    private String[] NameSpacesTitle;
    private String[] ChannelCustomTags;
    private String[] ItemCustomFields;
    private String[] ItemCustomTags;
    private boolean customrss;
    private boolean displayitem;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        RssOutputMeta retval = (RssOutputMeta)super.clone();
        int nrfields = this.ChannelCustomFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.ChannelCustomFields[i] = this.ChannelCustomFields[i];
            retval.ChannelCustomTags[i] = this.ChannelCustomTags[i];
        }
        int nritemfields = this.ItemCustomFields.length;
        retval.allocateitem(nritemfields);
        for (int i = 0; i < nritemfields; ++i) {
            retval.ItemCustomFields[i] = this.ItemCustomFields[i];
            retval.ItemCustomTags[i] = this.ItemCustomTags[i];
        }
        int nramespaces = this.NameSpaces.length;
        retval.allocatenamespace(nramespaces);
        for (int i = 0; i < nramespaces; ++i) {
            retval.NameSpacesTitle[i] = this.NameSpacesTitle[i];
            retval.NameSpaces[i] = this.NameSpaces[i];
        }
        return retval;
    }

    public void allocate(int nrfields) {
        this.ChannelCustomFields = new String[nrfields];
        this.ChannelCustomTags = new String[nrfields];
    }

    public void allocateitem(int nrfields) {
        this.ItemCustomFields = new String[nrfields];
        this.ItemCustomTags = new String[nrfields];
    }

    public void allocatenamespace(int nrnamespaces) {
        this.NameSpaces = new String[nrnamespaces];
        this.NameSpacesTitle = new String[nrnamespaces];
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getFileNameField() {
        return this.filenamefield;
    }

    public void setFileNameField(String filenamefield) {
        this.filenamefield = filenamefield;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isStepNrInFilename() {
        return this.stepNrInFilename;
    }

    public void setStepNrInFilename(boolean stepNrInFilename) {
        this.stepNrInFilename = stepNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean AddToResult() {
        return this.AddToResult;
    }

    public void setAddToResult(boolean AddToResult) {
        this.AddToResult = AddToResult;
    }

    public void setCustomRss(boolean customrss) {
        this.customrss = customrss;
    }

    public boolean isCustomRss() {
        return this.customrss;
    }

    public void setDisplayItem(boolean displayitem) {
        this.displayitem = displayitem;
    }

    public boolean isDisplayItem() {
        return this.displayitem;
    }

    public boolean AddImage() {
        return this.addimage;
    }

    public void setAddImage(boolean addimage) {
        this.addimage = addimage;
    }

    public boolean AddGeoRSS() {
        return this.addgeorss;
    }

    public void setAddGeoRSS(boolean addgeorss) {
        this.addgeorss = addgeorss;
    }

    public boolean useGeoRSSGML() {
        return this.usegeorssgml;
    }

    public void setUseGeoRSSGML(boolean usegeorssgml) {
        this.usegeorssgml = usegeorssgml;
    }

    public boolean isFilenameInField() {
        return this.isfilenameinfield;
    }

    public void setFilenameInField(boolean isfilenameinfield) {
        this.isfilenameinfield = isfilenameinfield;
    }

    public String[] getChannelCustomFields() {
        return this.ChannelCustomFields;
    }

    public void setChannelCustomFields(String[] ChannelCustomFields) {
        this.ChannelCustomFields = ChannelCustomFields;
    }

    public String[] getNameSpaces() {
        return this.NameSpaces;
    }

    public void setNameSpaces(String[] NameSpaces) {
        this.NameSpaces = NameSpaces;
    }

    public String[] getNameSpacesTitle() {
        return this.NameSpacesTitle;
    }

    public void setNameSpacesTitle(String[] NameSpacesTitle) {
        this.NameSpacesTitle = NameSpacesTitle;
    }

    public String[] getChannelCustomTags() {
        return this.ChannelCustomTags;
    }

    public void setChannelCustomTags(String[] ChannelCustomTags) {
        this.ChannelCustomTags = ChannelCustomTags;
    }

    public String[] getItemCustomTags() {
        return this.ItemCustomTags;
    }

    public void setItemCustomTags(String[] ItemCustomTags) {
        this.ItemCustomTags = ItemCustomTags;
    }

    public String[] getItemCustomFields() {
        return this.ItemCustomFields;
    }

    public void setItemCustomFields(String[] ItemCustomTags) {
        this.ItemCustomTags = ItemCustomTags;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public String[] getFiles(VariableSpace space) throws KettleStepException {
        int nr;
        int copies = 1;
        int parts = 1;
        if (this.stepNrInFilename) {
            copies = 3;
        }
        if (this.partNrInFilename) {
            parts = 3;
        }
        if ((nr = copies * parts) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int part = 0; part < parts; ++part) {
                retval[i] = this.buildFilename(space, copy);
                ++i;
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    private String getFilename(VariableSpace space) throws KettleStepException {
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject((String)space.environmentSubstitute(this.getFileName()));
            String string = KettleVFS.getFilename((FileObject)file);
            return string;
        }
        catch (Exception e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"RssOutput.Meta.ErrorGettingFile", (String[])new String[]{this.getFileName()}), (Throwable)e);
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public String buildFilename(VariableSpace space, int stepnr) throws KettleStepException {
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = this.getFilename(space);
        Date now = new Date();
        if (this.dateInFilename) {
            daf.applyPattern("yyyMMdd");
            String d = daf.format(now);
            retval = retval + "_" + d;
        }
        if (this.timeInFilename) {
            daf.applyPattern("HHmmss");
            String t = daf.format(now);
            retval = retval + "_" + t;
        }
        if (this.stepNrInFilename) {
            retval = retval + "_" + stepnr;
        }
        if (this.extension != null && this.extension.length() != 0) {
            retval = retval + "." + this.extension;
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.displayitem = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"displayitem"));
            this.customrss = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"customrss"));
            this.channeltitle = XMLHandler.getTagValue((Node)stepnode, (String)"channel_title");
            this.channeldescription = XMLHandler.getTagValue((Node)stepnode, (String)"channel_description");
            this.channellink = XMLHandler.getTagValue((Node)stepnode, (String)"channel_link");
            this.channelpubdate = XMLHandler.getTagValue((Node)stepnode, (String)"channel_pubdate");
            this.channelcopyright = XMLHandler.getTagValue((Node)stepnode, (String)"channel_copyright");
            this.channelimagetitle = XMLHandler.getTagValue((Node)stepnode, (String)"channel_image_title");
            this.channelimagelink = XMLHandler.getTagValue((Node)stepnode, (String)"channel_image_link");
            this.channelimageurl = XMLHandler.getTagValue((Node)stepnode, (String)"channel_image_url");
            this.channelimagedescription = XMLHandler.getTagValue((Node)stepnode, (String)"channel_image_description");
            this.channellanguage = XMLHandler.getTagValue((Node)stepnode, (String)"channel_language");
            this.channelauthor = XMLHandler.getTagValue((Node)stepnode, (String)"channel_author");
            this.version = XMLHandler.getTagValue((Node)stepnode, (String)"version");
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.addimage = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addimage"));
            this.itemtitle = XMLHandler.getTagValue((Node)stepnode, (String)"item_title");
            this.itemdescription = XMLHandler.getTagValue((Node)stepnode, (String)"item_description");
            this.itemlink = XMLHandler.getTagValue((Node)stepnode, (String)"item_link");
            this.itempubdate = XMLHandler.getTagValue((Node)stepnode, (String)"item_pubdate");
            this.itemauthor = XMLHandler.getTagValue((Node)stepnode, (String)"item_author");
            this.addgeorss = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addgeorss"));
            this.usegeorssgml = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"usegeorssgml"));
            this.geopointlat = XMLHandler.getTagValue((Node)stepnode, (String)"geopointlat");
            this.geopointlong = XMLHandler.getTagValue((Node)stepnode, (String)"geopointlong");
            this.filenamefield = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"filename_field");
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.isfilenameinfield = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"is_filename_in_field"));
            this.createparentfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"create_parent_folder"));
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"extention");
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"split"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_time"));
            this.AddToResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"AddToResult"));
            Node keys = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrchannelfields = XMLHandler.countNodes((Node)keys, (String)"channel_custom_fields");
            this.allocate(nrchannelfields);
            for (int i = 0; i < nrchannelfields; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)keys, (String)"channel_custom_fields", (int)i);
                this.ChannelCustomTags[i] = XMLHandler.getTagValue((Node)knode, (String)"tag");
                this.ChannelCustomFields[i] = XMLHandler.getTagValue((Node)knode, (String)"field");
            }
            int nritemfields = XMLHandler.countNodes((Node)keys, (String)"item_custom_fields");
            this.allocateitem(nritemfields);
            for (int i = 0; i < nritemfields; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)keys, (String)"item_custom_fields", (int)i);
                this.ItemCustomTags[i] = XMLHandler.getTagValue((Node)knode, (String)"tag");
                this.ItemCustomFields[i] = XMLHandler.getTagValue((Node)knode, (String)"field");
            }
            Node keysNameSpaces = XMLHandler.getSubNode((Node)stepnode, (String)"namespaces");
            int nrnamespaces = XMLHandler.countNodes((Node)keysNameSpaces, (String)"namespace");
            this.allocatenamespace(nrnamespaces);
            for (int i = 0; i < nrnamespaces; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)keysNameSpaces, (String)"namespace", (int)i);
                this.NameSpacesTitle[i] = XMLHandler.getTagValue((Node)knode, (String)"namespace_tag");
                this.NameSpaces[i] = XMLHandler.getTagValue((Node)knode, (String)"namespace_value");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.displayitem = true;
        this.customrss = false;
        this.channeltitle = null;
        this.channeldescription = null;
        this.channellink = null;
        this.channelpubdate = null;
        this.channelcopyright = null;
        this.channelimagetitle = null;
        this.channelimagelink = null;
        this.channelimageurl = null;
        this.channelimagedescription = null;
        this.channellanguage = null;
        this.channelauthor = null;
        this.createparentfolder = false;
        this.isfilenameinfield = false;
        this.version = "rss_2.0";
        this.encoding = "iso-8859-1";
        this.filenamefield = null;
        this.isfilenameinfield = false;
        this.itemtitle = null;
        this.itemdescription = null;
        this.itemlink = null;
        this.itempubdate = null;
        this.itemauthor = null;
        this.geopointlat = null;
        this.geopointlong = null;
        int nrchannelfields = 0;
        this.allocate(nrchannelfields);
        for (int i = 0; i < nrchannelfields; ++i) {
            this.ChannelCustomFields[i] = "field" + i;
            this.ChannelCustomTags[i] = "tag" + i;
        }
        int nritemfields = 0;
        this.allocateitem(nritemfields);
        for (int i = 0; i < nritemfields; ++i) {
            this.ItemCustomFields[i] = "field" + i;
            this.ItemCustomTags[i] = "tag" + i;
        }
        int nrnamespaces = 0;
        this.allocatenamespace(nrnamespaces);
        for (int i = 0; i < nrnamespaces; ++i) {
            this.NameSpacesTitle[i] = "namespace_title" + i;
            this.NameSpaces[i] = "namespace" + i;
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"displayitem", (boolean)this.displayitem));
        retval.append("    " + XMLHandler.addTagValue((String)"customrss", (boolean)this.customrss));
        retval.append("    " + XMLHandler.addTagValue((String)"channel_title", (String)this.channeltitle));
        retval.append("    " + XMLHandler.addTagValue((String)"channel_description", (String)this.channeldescription));
        retval.append("    " + XMLHandler.addTagValue((String)"channel_link", (String)this.channellink));
        retval.append("    " + XMLHandler.addTagValue((String)"channel_pubdate", (String)this.channelpubdate));
        retval.append("    " + XMLHandler.addTagValue((String)"channel_copyright", (String)this.channelcopyright));
        retval.append("    " + XMLHandler.addTagValue((String)"channel_image_title", (String)this.channelimagetitle));
        retval.append("    " + XMLHandler.addTagValue((String)"channel_image_link", (String)this.channelimagelink));
        retval.append("    " + XMLHandler.addTagValue((String)"channel_image_url", (String)this.channelimageurl));
        retval.append("    " + XMLHandler.addTagValue((String)"channel_image_description", (String)this.channelimagedescription));
        retval.append("    " + XMLHandler.addTagValue((String)"channel_language", (String)this.channellanguage));
        retval.append("    " + XMLHandler.addTagValue((String)"channel_author", (String)this.channelauthor));
        retval.append("    " + XMLHandler.addTagValue((String)"version", (String)this.version));
        retval.append("    " + XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XMLHandler.addTagValue((String)"addimage", (boolean)this.addimage));
        retval.append("    " + XMLHandler.addTagValue((String)"item_title", (String)this.itemtitle));
        retval.append("    " + XMLHandler.addTagValue((String)"item_description", (String)this.itemdescription));
        retval.append("    " + XMLHandler.addTagValue((String)"item_link", (String)this.itemlink));
        retval.append("    " + XMLHandler.addTagValue((String)"item_pubdate", (String)this.itempubdate));
        retval.append("    " + XMLHandler.addTagValue((String)"item_author", (String)this.itemauthor));
        retval.append("    " + XMLHandler.addTagValue((String)"addgeorss", (boolean)this.addgeorss));
        retval.append("    " + XMLHandler.addTagValue((String)"usegeorssgml", (boolean)this.usegeorssgml));
        retval.append("    " + XMLHandler.addTagValue((String)"geopointlat", (String)this.geopointlat));
        retval.append("    " + XMLHandler.addTagValue((String)"geopointlong", (String)this.geopointlong));
        retval.append("    <file>" + Const.CR);
        retval.append("      " + XMLHandler.addTagValue((String)"filename_field", (String)this.filenamefield));
        retval.append("      " + XMLHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append("      " + XMLHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      " + XMLHandler.addTagValue((String)"split", (boolean)this.stepNrInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"is_filename_in_field", (boolean)this.isfilenameinfield));
        retval.append("      " + XMLHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append("    " + XMLHandler.addTagValue((String)"addtoresult", (boolean)this.AddToResult));
        retval.append("      </file>" + Const.CR);
        retval.append("      <fields>").append(Const.CR);
        for (i = 0; i < this.ChannelCustomFields.length; ++i) {
            retval.append("        <channel_custom_fields>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"tag", (String)this.ChannelCustomTags[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"field", (String)this.ChannelCustomFields[i]));
            retval.append("        </channel_custom_fields>").append(Const.CR);
        }
        for (i = 0; i < this.ItemCustomFields.length; ++i) {
            retval.append("        <Item_custom_fields>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"tag", (String)this.ItemCustomTags[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"field", (String)this.ItemCustomFields[i]));
            retval.append("        </Item_custom_fields>").append(Const.CR);
        }
        retval.append("      </fields>").append(Const.CR);
        retval.append("      <namespaces>").append(Const.CR);
        for (i = 0; i < this.NameSpaces.length; ++i) {
            retval.append("        <namespace>").append(Const.CR);
            retval.append("          ").append(XMLHandler.addTagValue((String)"namespace_tag", (String)this.NameSpacesTitle[i]));
            retval.append("          ").append(XMLHandler.addTagValue((String)"namespace_value", (String)this.NameSpaces[i]));
            retval.append("        </namespace>").append(Const.CR);
        }
        retval.append("      </namespaces>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.displayitem = rep.getStepAttributeBoolean(id_step, "displayitem");
            this.customrss = rep.getStepAttributeBoolean(id_step, "customrss");
            this.channeltitle = rep.getStepAttributeString(id_step, "channel_title");
            this.channeldescription = rep.getStepAttributeString(id_step, "channel_description");
            this.channellink = rep.getStepAttributeString(id_step, "channel_link");
            this.channelpubdate = rep.getStepAttributeString(id_step, "channel_pubdate");
            this.channelcopyright = rep.getStepAttributeString(id_step, "channel_copyright");
            this.channelimagetitle = rep.getStepAttributeString(id_step, "channel_image_title");
            this.channelimagelink = rep.getStepAttributeString(id_step, "channel_image_link");
            this.channelimageurl = rep.getStepAttributeString(id_step, "channel_image_url");
            this.channelimagedescription = rep.getStepAttributeString(id_step, "channel_image_description");
            this.channellanguage = rep.getStepAttributeString(id_step, "channel_language");
            this.channelauthor = rep.getStepAttributeString(id_step, "channel_author");
            this.version = rep.getStepAttributeString(id_step, "version");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.addimage = rep.getStepAttributeBoolean(id_step, "addimage");
            this.itemtitle = rep.getStepAttributeString(id_step, "item_title");
            this.itemdescription = rep.getStepAttributeString(id_step, "item_description");
            this.itemlink = rep.getStepAttributeString(id_step, "item_link");
            this.itempubdate = rep.getStepAttributeString(id_step, "item_pubdate");
            this.itemauthor = rep.getStepAttributeString(id_step, "item_author");
            this.addgeorss = rep.getStepAttributeBoolean(id_step, "addgeorss");
            this.usegeorssgml = rep.getStepAttributeBoolean(id_step, "usegeorssgml");
            this.geopointlat = rep.getStepAttributeString(id_step, "geopointlat");
            this.geopointlong = rep.getStepAttributeString(id_step, "geopointlong");
            this.filenamefield = rep.getStepAttributeString(id_step, "filename_field");
            this.fileName = rep.getStepAttributeString(id_step, "file_name");
            this.extension = rep.getStepAttributeString(id_step, "file_extention");
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_stepnr");
            this.partNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_partnr");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "file_add_date");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "file_add_time");
            this.isfilenameinfield = rep.getStepAttributeBoolean(id_step, "is_filename_in_field");
            this.createparentfolder = rep.getStepAttributeBoolean(id_step, "create_parent_folder");
            this.AddToResult = rep.getStepAttributeBoolean(id_step, "addtoresult");
            int nrchannel = rep.countNrStepAttributes(id_step, "channel_custom_field");
            this.allocate(nrchannel);
            for (int i = 0; i < nrchannel; ++i) {
                this.ChannelCustomTags[i] = rep.getStepAttributeString(id_step, i, "channel_custom_tag");
                this.ChannelCustomFields[i] = rep.getStepAttributeString(id_step, i, "channel_custom_field");
            }
            int nritem = rep.countNrStepAttributes(id_step, "item_custom_field");
            this.allocateitem(nritem);
            for (int i = 0; i < nritem; ++i) {
                this.ItemCustomTags[i] = rep.getStepAttributeString(id_step, i, "item_custom_tag");
                this.ItemCustomFields[i] = rep.getStepAttributeString(id_step, i, "item_custom_field");
            }
            int nrnamespaces = rep.countNrStepAttributes(id_step, "namespace_tag");
            this.allocatenamespace(nrnamespaces);
            for (int i = 0; i < nrnamespaces; ++i) {
                this.NameSpacesTitle[i] = rep.getStepAttributeString(id_step, i, "namespace_tag");
                this.NameSpaces[i] = rep.getStepAttributeString(id_step, i, "namespace_value");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "displayitem", this.displayitem);
            rep.saveStepAttribute(id_transformation, id_step, "customrss", this.customrss);
            rep.saveStepAttribute(id_transformation, id_step, "channel_title", this.channeltitle);
            rep.saveStepAttribute(id_transformation, id_step, "channel_description", this.channeldescription);
            rep.saveStepAttribute(id_transformation, id_step, "channel_link", this.channellink);
            rep.saveStepAttribute(id_transformation, id_step, "channel_pubdate", this.channelpubdate);
            rep.saveStepAttribute(id_transformation, id_step, "channel_copyright", this.channelcopyright);
            rep.saveStepAttribute(id_transformation, id_step, "channel_image_title", this.channelimagetitle);
            rep.saveStepAttribute(id_transformation, id_step, "channel_image_link", this.channelimagelink);
            rep.saveStepAttribute(id_transformation, id_step, "channel_image_url", this.channelimageurl);
            rep.saveStepAttribute(id_transformation, id_step, "channel_image_description", this.channelimagedescription);
            rep.saveStepAttribute(id_transformation, id_step, "channel_author", this.channelauthor);
            rep.saveStepAttribute(id_transformation, id_step, "channel_language", this.channellanguage);
            rep.saveStepAttribute(id_transformation, id_step, "version", this.version);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "addimage", this.addimage);
            rep.saveStepAttribute(id_transformation, id_step, "item_title", this.itemtitle);
            rep.saveStepAttribute(id_transformation, id_step, "item_description", this.itemdescription);
            rep.saveStepAttribute(id_transformation, id_step, "item_link", this.itemlink);
            rep.saveStepAttribute(id_transformation, id_step, "item_pubdate", this.itempubdate);
            rep.saveStepAttribute(id_transformation, id_step, "item_author", this.itemauthor);
            rep.saveStepAttribute(id_transformation, id_step, "addgeorss", this.addgeorss);
            rep.saveStepAttribute(id_transformation, id_step, "usegeorssgml", this.usegeorssgml);
            rep.saveStepAttribute(id_transformation, id_step, "geopointlat", this.geopointlat);
            rep.saveStepAttribute(id_transformation, id_step, "geopointlong", this.geopointlong);
            rep.saveStepAttribute(id_transformation, id_step, "filename_field", this.filenamefield);
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "file_extention", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_stepnr", this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_partnr", this.partNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_date", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_time", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "is_filename_in_field", this.isfilenameinfield);
            rep.saveStepAttribute(id_transformation, id_step, "create_parent_folder", this.createparentfolder);
            rep.saveStepAttribute(id_transformation, id_step, "addtoresult", this.AddToResult);
            for (i = 0; i < this.ChannelCustomFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "channel_custom_field", this.ChannelCustomFields[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "channel_custom_tag", this.ChannelCustomTags[i]);
            }
            for (i = 0; i < this.ItemCustomFields.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "item_custom_field", this.ItemCustomFields[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "item_custom_tag", this.ItemCustomTags[i]);
            }
            for (i = 0; i < this.NameSpaces.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "namespace_tag", this.NameSpacesTitle[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "namespace_value", this.NameSpaces[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RssOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RssOutputMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RssOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RssOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepDataInterface getStepData() {
        return new RssOutputData();
    }

    public String getChannelTitle() {
        return this.channeltitle;
    }

    public String getChannelDescription() {
        return this.channeldescription;
    }

    public String getChannelLink() {
        return this.channellink;
    }

    public String getChannelPubDate() {
        return this.channelpubdate;
    }

    public String getChannelImageLink() {
        return this.channelimagelink;
    }

    public String getChannelImageUrl() {
        return this.channelimageurl;
    }

    public String getChannelImageDescription() {
        return this.channelimagedescription;
    }

    public String getChannelImageTitle() {
        return this.channelimagetitle;
    }

    public String getChannelLanguage() {
        return this.channellanguage;
    }

    public String getChannelAuthor() {
        return this.channelauthor;
    }

    public void setChannelAuthor(String channelauthor) {
        this.channelauthor = channelauthor;
    }

    public void setChannelTitle(String channeltitle) {
        this.channeltitle = channeltitle;
    }

    public void setChannelLink(String channellink) {
        this.channellink = channellink;
    }

    public void setChannelPubDate(String channelpubdate) {
        this.channelpubdate = channelpubdate;
    }

    public void setChannelImageTitle(String channelimagetitle) {
        this.channelimagetitle = channelimagetitle;
    }

    public void setChannelImageLink(String channelimagelink) {
        this.channelimagelink = channelimagelink;
    }

    public void setChannelImageUrl(String channelimageurl) {
        this.channelimageurl = channelimageurl;
    }

    public void setChannelImageDescription(String channelimagedescription) {
        this.channelimagedescription = channelimagedescription;
    }

    public void setChannelLanguage(String channellanguage) {
        this.channellanguage = channellanguage;
    }

    public void setChannelDescription(String channeldescription) {
        this.channeldescription = channeldescription;
    }

    public String getItemTitle() {
        return this.itemtitle;
    }

    public String getGeoPointLat() {
        return this.geopointlat;
    }

    public void setGeoPointLat(String geopointlat) {
        this.geopointlat = geopointlat;
    }

    public String getGeoPointLong() {
        return this.geopointlong;
    }

    public void setGeoPointLong(String geopointlong) {
        this.geopointlong = geopointlong;
    }

    public String getItemDescription() {
        return this.itemdescription;
    }

    public String getItemLink() {
        return this.itemlink;
    }

    public String getItemPubDate() {
        return this.itempubdate;
    }

    public String getItemAuthor() {
        return this.itemauthor;
    }

    public void setItemTitle(String itemtitle) {
        this.itemtitle = itemtitle;
    }

    public void setItemDescription(String itemdescription) {
        this.itemdescription = itemdescription;
    }

    public void setItemLink(String itemlink) {
        this.itemlink = itemlink;
    }

    public void setItemPubDate(String itempubdate) {
        this.itempubdate = itempubdate;
    }

    public void setItemAuthor(String itemauthor) {
        this.itemauthor = itemauthor;
    }

    public String getChannelCopyright() {
        return this.channelcopyright;
    }

    public void setChannelCopyright(String channelcopyright) {
        this.channelcopyright = channelcopyright;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new RssOutput(stepMeta, stepDataInterface, cnr, tr, trans);
    }
}

