/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.janino;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInjectionUtil;
import org.pentaho.di.trans.step.StepMetaInjectionEntryInterface;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.janino.JaninoMeta;
import org.pentaho.di.trans.steps.janino.JaninoMetaFunction;

public class JaninoMetaInjection
implements StepMetaInjectionInterface {
    private JaninoMeta meta;

    public JaninoMetaInjection(JaninoMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        Entry[] fieldsEntries;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.EXPRESSION_FIELDS.name(), 0, Entry.EXPRESSION_FIELDS.description);
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.EXPRESSION_FIELD.name(), 0, Entry.EXPRESSION_FIELD.description);
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : fieldsEntries = new Entry[]{Entry.NEW_FIELDNAME, Entry.JAVA_EXPRESSION, Entry.VALUE_TYPE, Entry.LENGTH, Entry.PRECISION, Entry.REPLACE_VALUE}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<String> javaExpressions = new ArrayList<String>();
        ArrayList<String> valueTypes = new ArrayList<String>();
        ArrayList<String> lengths = new ArrayList<String>();
        ArrayList<String> precisions = new ArrayList<String>();
        ArrayList<String> replaceValues = new ArrayList<String>();
        block11: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case EXPRESSION_FIELDS: {
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        Entry fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.EXPRESSION_FIELD) continue;
                        String newFieldname = null;
                        String javaExpression = null;
                        String valueType = null;
                        String length = null;
                        String precision = null;
                        String replaceValue = null;
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case NEW_FIELDNAME: {
                                    newFieldname = value;
                                    break;
                                }
                                case JAVA_EXPRESSION: {
                                    javaExpression = value;
                                    break;
                                }
                                case VALUE_TYPE: {
                                    valueType = value;
                                    break;
                                }
                                case LENGTH: {
                                    length = value;
                                    break;
                                }
                                case PRECISION: {
                                    precision = value;
                                    break;
                                }
                                case REPLACE_VALUE: {
                                    replaceValue = value;
                                    break;
                                }
                            }
                        }
                        fieldNames.add(newFieldname);
                        javaExpressions.add(javaExpression);
                        valueTypes.add(valueType);
                        lengths.add(length);
                        precisions.add(precision);
                        replaceValues.add(replaceValue);
                    }
                    continue block11;
                }
            }
        }
        if (fieldNames.size() > 0) {
            JaninoMetaFunction[] fields = new JaninoMetaFunction[fieldNames.size()];
            Iterator iFieldNames = fieldNames.iterator();
            Iterator iJavaExpressions = javaExpressions.iterator();
            Iterator iValueTypes = valueTypes.iterator();
            Iterator iLengths = lengths.iterator();
            Iterator iPrecisions = precisions.iterator();
            Iterator iReplaceValues = replaceValues.iterator();
            int i = 0;
            while (iFieldNames.hasNext()) {
                fields[i] = new JaninoMetaFunction((String)iFieldNames.next(), (String)iJavaExpressions.next(), ValueMeta.getType((String)((String)iValueTypes.next())), Const.toInt((String)((String)iLengths.next()), (int)-1), Const.toInt((String)((String)iPrecisions.next()), (int)-1), (String)iReplaceValues.next());
                ++i;
            }
            this.meta.setFormula(fields);
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        ArrayList<StepInjectionMetaEntry> list = new ArrayList<StepInjectionMetaEntry>();
        StepInjectionMetaEntry fieldsEntry = StepInjectionUtil.getEntry(Entry.EXPRESSION_FIELDS);
        list.add(fieldsEntry);
        for (int i = 0; i < this.meta.getFormula().length; ++i) {
            StepInjectionMetaEntry fieldEntry = StepInjectionUtil.getEntry(Entry.EXPRESSION_FIELD);
            List<StepInjectionMetaEntry> details = fieldEntry.getDetails();
            details.add(StepInjectionUtil.getEntry(Entry.NEW_FIELDNAME, this.meta.getFormula()[i].getFieldName()));
            details.add(StepInjectionUtil.getEntry(Entry.JAVA_EXPRESSION, this.meta.getFormula()[i].getFormula()));
            details.add(StepInjectionUtil.getEntry(Entry.VALUE_TYPE, ValueMeta.getTypeDesc((int)this.meta.getFormula()[i].getValueType())));
            details.add(StepInjectionUtil.getEntry(Entry.LENGTH, this.meta.getFormula()[i].getValueLength()));
            details.add(StepInjectionUtil.getEntry(Entry.PRECISION, this.meta.getFormula()[i].getValuePrecision()));
            details.add(StepInjectionUtil.getEntry(Entry.REPLACE_VALUE, this.meta.getFormula()[i].getReplaceField()));
            fieldsEntry.getDetails().add(fieldEntry);
        }
        return list;
    }

    public JaninoMeta getMeta() {
        return this.meta;
    }

    public static enum Entry implements StepMetaInjectionEntryInterface
    {
        EXPRESSION_FIELDS(0, "The formula fields"),
        EXPRESSION_FIELD(0, "One formula field"),
        NEW_FIELDNAME(2, "New field"),
        JAVA_EXPRESSION(2, "Java expression"),
        VALUE_TYPE(2, "Value type (For valid values go to http://wiki.pentaho.com/display/EAI/User+Defined+Java+Expression)"),
        LENGTH(2, "Length"),
        PRECISION(2, "Precision"),
        REPLACE_VALUE(2, "Replace value");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        @Override
        public int getValueType() {
            return this.valueType;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

