/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.formula;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;
import org.pentaho.reporting.libraries.formula.operators.OperatorFactory;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.AnyType;

public class RowForumulaContext
implements FormulaContext {
    private RowMetaInterface rowMeta;
    private FormulaContext formulaContext = new DefaultFormulaContext();
    private Map<String, Integer> valueIndexMap;
    private Object[] rowData;

    public RowForumulaContext(RowMetaInterface row) {
        this.rowMeta = row;
        this.rowData = null;
        this.valueIndexMap = new Hashtable<String, Integer>();
    }

    public Type resolveReferenceType(Object name) {
        return AnyType.TYPE;
    }

    public Object resolveReference(Object name) throws EvaluationException {
        if (name instanceof String) {
            ValueMetaInterface valueMeta;
            Integer idx = this.valueIndexMap.get(name);
            if (idx != null) {
                valueMeta = this.rowMeta.getValueMeta(idx.intValue());
            } else {
                int index = this.rowMeta.indexOfValue((String)name);
                if (index < 0) {
                    LibFormulaErrorValue errorValue = new LibFormulaErrorValue(502);
                    throw new EvaluationException((ErrorValue)errorValue);
                }
                valueMeta = this.rowMeta.getValueMeta(index);
                idx = new Integer(index);
                this.valueIndexMap.put((String)name, idx);
            }
            Object valueData = this.rowData[idx];
            try {
                return RowForumulaContext.getPrimitive(valueMeta, valueData);
            }
            catch (KettleValueException e) {
                throw new EvaluationException((ErrorValue)LibFormulaErrorValue.ERROR_ARITHMETIC_VALUE);
            }
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.formulaContext.getConfiguration();
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.formulaContext.getFunctionRegistry();
    }

    public LocalizationContext getLocalizationContext() {
        return this.formulaContext.getLocalizationContext();
    }

    public OperatorFactory getOperatorFactory() {
        return this.formulaContext.getOperatorFactory();
    }

    public TypeRegistry getTypeRegistry() {
        return this.formulaContext.getTypeRegistry();
    }

    public boolean isReferenceDirty(Object name) throws EvaluationException {
        return this.formulaContext.isReferenceDirty(name);
    }

    public RowMetaInterface getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void setRowData(Object[] rowData) {
        this.rowData = rowData;
    }

    public Object[] getRowData() {
        return this.rowData;
    }

    public static Object getPrimitive(ValueMetaInterface valueMeta, Object valueData) throws KettleValueException {
        switch (valueMeta.getType()) {
            case 6: {
                return valueMeta.getBigNumber(valueData);
            }
            case 8: {
                return valueMeta.getBinary(valueData);
            }
            case 4: {
                return valueMeta.getBoolean(valueData);
            }
            case 3: {
                return valueMeta.getDate(valueData);
            }
            case 5: {
                return valueMeta.getInteger(valueData);
            }
            case 1: {
                return valueMeta.getNumber(valueData);
            }
            case 2: {
                return valueMeta.getString(valueData);
            }
        }
        return null;
    }

    public static Class<?> getPrimitiveClass(int valueType) {
        switch (valueType) {
            case 6: {
                return BigDecimal.class;
            }
            case 8: {
                return new byte[0].getClass();
            }
            case 4: {
                return Boolean.class;
            }
            case 3: {
                return Date.class;
            }
            case 5: {
                return Long.class;
            }
            case 1: {
                return Double.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public Date getCurrentDate() {
        return new Date();
    }
}

