/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileinput;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.fileinput.BaseFileInputField;

public abstract class BaseFileInputStepMeta
extends BaseStepMeta {
    private Class<?> PKG = this.getClass();
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    public static final String NO = "N";
    public static final String YES = "Y";
    public final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(this.PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(this.PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public InputFiles inputFiles = new InputFiles();
    public ErrorHandling errorHandling = new ErrorHandling();
    public AdditionalOutputFields additionalOutputFields = new AdditionalOutputFields();

    @Override
    public Object clone() {
        BaseFileInputStepMeta retval = (BaseFileInputStepMeta)super.clone();
        retval.inputFiles = (InputFiles)this.inputFiles.clone();
        retval.errorHandling = (ErrorHandling)this.errorHandling.clone();
        retval.additionalOutputFields = (AdditionalOutputFields)this.additionalOutputFields.clone();
        return retval;
    }

    public void inputFiles_fileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.inputFiles.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] inputFiles_includeSubFolders() {
        return this.inputFiles.includeSubFolders;
    }

    public void inputFiles_includeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.inputFiles.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(this.RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public FileInputList getFileInputList(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.inputFiles.fileName, (String[])this.inputFiles.fileMask, (String[])this.inputFiles.excludeFileMask, (String[])this.inputFiles.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    public boolean[] includeSubFolderBoolean() {
        int len = this.inputFiles.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.inputFiles.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(TransMeta transMeta, StepMeta stepInfo) {
        ArrayList<ResourceReference> references = new ArrayList<ResourceReference>(5);
        ResourceReference reference = new ResourceReference(stepInfo);
        references.add(reference);
        String[] textFiles = FileInputList.createFilePathList((VariableSpace)transMeta, (String[])this.inputFiles.fileName, (String[])this.inputFiles.fileMask, (String[])this.inputFiles.excludeFileMask, (String[])this.inputFiles.fileRequired, (boolean[])this.includeSubFolderBoolean());
        if (textFiles != null) {
            for (int i = 0; i < textFiles.length; ++i) {
                reference.getEntries().add(new ResourceEntry(textFiles[i], ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public abstract String getEncoding();

    public static class AdditionalOutputFields
    implements Cloneable {
        public String shortFilenameField;
        public String extensionField;
        public String pathField;
        public String sizeField;
        public String hiddenField;
        public String lastModificationField;
        public String uriField;
        public String rootUriField;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        public void normalize() {
            if (StringUtils.isBlank((String)this.shortFilenameField)) {
                this.shortFilenameField = null;
            }
            if (StringUtils.isBlank((String)this.extensionField)) {
                this.extensionField = null;
            }
            if (StringUtils.isBlank((String)this.pathField)) {
                this.pathField = null;
            }
            if (StringUtils.isBlank((String)this.sizeField)) {
                this.sizeField = null;
            }
            if (StringUtils.isBlank((String)this.hiddenField)) {
                this.hiddenField = null;
            }
            if (StringUtils.isBlank((String)this.lastModificationField)) {
                this.lastModificationField = null;
            }
            if (StringUtils.isBlank((String)this.uriField)) {
                this.uriField = null;
            }
            if (StringUtils.isBlank((String)this.rootUriField)) {
                this.rootUriField = null;
            }
        }
    }

    public static class ErrorHandling
    implements Cloneable {
        public boolean errorIgnored;
        public String fileErrorField;
        public String fileErrorMessageField;
        public boolean skipBadFiles;
        public String warningFilesDestinationDirectory;
        public String warningFilesExtension;
        public String errorFilesDestinationDirectory;
        public String errorFilesExtension;
        public String lineNumberFilesDestinationDirectory;
        public String lineNumberFilesExtension;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    public static class InputFiles
    implements Cloneable {
        public String[] fileName = new String[0];
        public String[] fileMask = new String[0];
        public String[] excludeFileMask = new String[0];
        public String[] fileRequired = new String[0];
        public String[] includeSubFolders = new String[0];
        public boolean acceptingFilenames;
        public String acceptingStepName;
        public boolean passingThruFields;
        public String acceptingField;
        public BaseFileInputField[] inputFields = new BaseFileInputField[0];
        public boolean isaddresult;

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

