/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.execprocess;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.execprocess.ExecProcessData;
import org.pentaho.di.trans.steps.execprocess.ExecProcessMeta;
import org.pentaho.di.trans.steps.execprocess.ProcessResult;

public class ExecProcess
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = ExecProcessMeta.class;
    private ExecProcessMeta meta;
    private ExecProcessData data;

    public ExecProcess(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block13: {
            this.meta = (ExecProcessMeta)smi;
            this.data = (ExecProcessData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.previousRowMeta = this.getInputRowMeta().clone();
                this.data.NrPrevFields = this.data.previousRowMeta.size();
                this.data.outputRowMeta = this.data.previousRowMeta;
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (Const.isEmpty((String)this.meta.getProcessField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.Error.ProcessFieldMissing", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ExecProcess.Error.ProcessFieldMissing", (String[])new String[0]));
                }
                if (this.data.indexOfProcess < 0) {
                    this.data.indexOfProcess = this.data.previousRowMeta.indexOfValue(this.meta.getProcessField());
                    if (this.data.indexOfProcess < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.Exception.CouldnotFindField", (String[])new String[0]) + "[" + this.meta.getProcessField() + "]");
                        throw new KettleException(BaseMessages.getString(PKG, (String)"ExecProcess.Exception.CouldnotFindField", (String[])new String[]{this.meta.getProcessField()}));
                    }
                }
            }
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            for (int i = 0; i < this.data.NrPrevFields; ++i) {
                outputRow[i] = r[i];
            }
            String processString = this.data.previousRowMeta.getString(r, this.data.indexOfProcess);
            ProcessResult processResult = new ProcessResult();
            try {
                if (Const.isEmpty((String)processString)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"ExecProcess.ProcessEmpty", (String[])new String[0]));
                }
                this.execProcess(processString, processResult);
                if (this.meta.isFailWhenNotSuccess() && processResult.getExistStatus() != 0L) {
                    String errorString = processResult.getErrorStream();
                    if (Const.isEmpty((String)errorString)) {
                        errorString = processResult.getOutputStream();
                    }
                    throw new KettleException(errorString);
                }
                int rowIndex = this.data.NrPrevFields;
                outputRow[rowIndex++] = processResult.getOutputStream();
                outputRow[rowIndex++] = processResult.getErrorStream();
                outputRow[rowIndex++] = processResult.getExistStatus();
                this.putRow(this.data.outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"ExecProcess.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block13;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "ExecProcess001");
            }
        }
        return true;
    }

    private void execProcess(String process, ProcessResult processresult) throws KettleException {
        Process p = null;
        try {
            String errorMsg = null;
            try {
                p = this.data.runtime.exec(process);
            }
            catch (Exception e) {
                errorMsg = e.getMessage();
            }
            if (p == null) {
                processresult.setErrorStream(errorMsg);
            } else {
                processresult.setOutputStream(this.getOutputString(new BufferedReader(new InputStreamReader(p.getInputStream()))));
                processresult.setErrorStream(this.getOutputString(new BufferedReader(new InputStreamReader(p.getErrorStream()))));
                p.waitFor();
                processresult.setExistStatus(p.exitValue());
            }
        }
        catch (IOException ioe) {
            throw new KettleException("IO exception while running the process " + process + "!", (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new KettleException("Interrupted exception while running the process " + process + "!", (Throwable)ie);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
    }

    private String getOutputString(BufferedReader b) throws IOException {
        String line;
        StringBuffer retvalBuff = new StringBuffer();
        String delim = this.meta.getOutputLineDelimiter();
        delim = delim == null ? "" : this.environmentSubstitute(delim);
        while ((line = b.readLine()) != null) {
            if (retvalBuff.length() > 0) {
                retvalBuff.append(delim);
            }
            retvalBuff.append(line);
        }
        return retvalBuff.toString();
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecProcessMeta)smi;
        this.data = (ExecProcessData)sdi;
        if (super.init(smi, sdi)) {
            if (Const.isEmpty((String)this.meta.getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"ExecProcess.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            this.data.runtime = Runtime.getRuntime();
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ExecProcessMeta)smi;
        this.data = (ExecProcessData)sdi;
        super.dispose(smi, sdi);
    }
}

