/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.denormaliser;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserMeta;
import org.pentaho.di.trans.steps.denormaliser.DenormaliserTargetField;

public class DenormaliserMetaInjection
implements StepMetaInjectionInterface {
    private DenormaliserMeta meta;

    public DenormaliserMetaInjection(DenormaliserMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry("FIELDS", 0, "All the fields on the spreadsheets");
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry("FIELD", 0, "All the fields on the spreadsheets");
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : Entry.values()) {
            if (entry.getValueType() == 0) continue;
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<DenormaliserTargetField> denormaliserTargetFields = new ArrayList<DenormaliserTargetField>();
        for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null || fieldsEntry != Entry.FIELDS) continue;
            for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                Entry fieldEntry = Entry.findEntry(lookField.getKey());
                if (fieldEntry == null || fieldEntry != Entry.FIELD) continue;
                DenormaliserTargetField inputField = new DenormaliserTargetField();
                List<StepInjectionMetaEntry> entries = lookField.getDetails();
                for (StepInjectionMetaEntry entry : entries) {
                    Entry metaEntry = Entry.findEntry(entry.getKey());
                    if (metaEntry == null) continue;
                    String value = (String)entry.getValue();
                    switch (metaEntry) {
                        case NAME: {
                            inputField.setFieldName(value);
                            break;
                        }
                        case KEY_VALUE: {
                            inputField.setKeyValue(value);
                            break;
                        }
                        case TARGET_NAME: {
                            inputField.setTargetName(value);
                            break;
                        }
                        case TARGET_TYPE: {
                            inputField.setTargetType(ValueMeta.getType((String)value));
                            break;
                        }
                        case TARGET_LENGTH: {
                            inputField.setTargetLength(Const.toInt((String)value, (int)-1));
                            break;
                        }
                        case TARGET_PRECISION: {
                            inputField.setTargetPrecision(Const.toInt((String)value, (int)-1));
                            break;
                        }
                        case TARGET_CURRENCY: {
                            inputField.setTargetCurrencySymbol(value);
                            break;
                        }
                        case TARGET_GROUP: {
                            inputField.setTargetGroupingSymbol(value);
                            break;
                        }
                        case TARGET_DECIMAL: {
                            inputField.setTargetDecimalSymbol(value);
                            break;
                        }
                        case TARGET_FORMAT: {
                            inputField.setTargetFormat(value);
                            break;
                        }
                        case TARGET_AGGREGATION: {
                            inputField.setTargetAggregationType(DenormaliserTargetField.getAggregationType(value));
                            break;
                        }
                    }
                }
                denormaliserTargetFields.add(inputField);
            }
        }
        this.meta.setDenormaliserTargetField(denormaliserTargetFields.toArray(new DenormaliserTargetField[denormaliserTargetFields.size()]));
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    public DenormaliserMeta getMeta() {
        return this.meta;
    }

    private static enum Entry {
        FIELDS(0, "All the fields"),
        FIELD(0, "One field"),
        TARGET_NAME(2, "Target field name"),
        NAME(2, "Value field name"),
        KEY_VALUE(2, "Key value"),
        TARGET_TYPE(2, "Target field type"),
        TARGET_LENGTH(2, "Target field length"),
        TARGET_PRECISION(2, "Target field precision"),
        TARGET_CURRENCY(2, "Target field currency symbol"),
        TARGET_DECIMAL(2, "Target field decimal symbol"),
        TARGET_GROUP(2, "Target field group symbol"),
        TARGET_FORMAT(2, "Target field format"),
        TARGET_AGGREGATION(2, "Target aggregation (-, SUM, AVERAGE, MIN, MAX, COUNT_ALL, CONCAT_COMMA)");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

