/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.trans.Trans;
import org.w3c.dom.Node;

public class TransDependency
implements XMLInterface,
Cloneable {
    private static Class<?> PKG = Trans.class;
    public static final String XML_TAG = "dependency";
    private DatabaseMeta db;
    private String tablename;
    private String fieldname;
    private ObjectId id;

    public TransDependency(DatabaseMeta db, String tablename, String fieldname) {
        this.db = db;
        this.tablename = tablename;
        this.fieldname = fieldname;
    }

    public TransDependency() {
        this(null, null, null);
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder(200);
        xml.append("      ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("        ").append(XMLHandler.addTagValue((String)"connection", (String)(this.db == null ? "" : this.db.getName())));
        xml.append("        ").append(XMLHandler.addTagValue((String)"table", (String)this.tablename));
        xml.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.fieldname));
        xml.append("      ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return xml.toString();
    }

    public TransDependency(Node depnode, List<DatabaseMeta> databases) throws KettleXMLException {
        try {
            String depcon = XMLHandler.getTagValue((Node)depnode, (String)"connection");
            this.db = DatabaseMeta.findDatabase(databases, (String)depcon);
            this.tablename = XMLHandler.getTagValue((Node)depnode, (String)"table");
            this.fieldname = XMLHandler.getTagValue((Node)depnode, (String)"field");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TransDependency.Exception.UnableToLoadTransformation", (String[])new String[0]), (Throwable)e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public void setDatabase(DatabaseMeta db) {
        this.db = db;
    }

    public DatabaseMeta getDatabase() {
        return this.db;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getFieldname() {
        return this.fieldname;
    }
}

