/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;

public class KettleDatabaseRepositoryNotePadDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    public KettleDatabaseRepositoryNotePadDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public synchronized ObjectId getNoteID(String note) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_NOTE"), this.quote("ID_NOTE"), this.quote("VALUE_STR"), note);
    }

    public RowMetaAndData getNote(ObjectId id_note) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_NOTE"), this.quote("ID_NOTE"), id_note);
    }

    public NotePadMeta loadNotePadMeta(ObjectId id_note) throws KettleException {
        NotePadMeta note = new NotePadMeta();
        try {
            note.setObjectId(id_note);
            RowMetaAndData r = this.getNote(id_note);
            if (r != null) {
                note.setNote(r.getString("VALUE_STR", ""));
                int x = (int)r.getInteger("GUI_LOCATION_X", 0L);
                int y = (int)r.getInteger("GUI_LOCATION_Y", 0L);
                note.setLocation(new Point(x, y));
                note.setWidth((int)r.getInteger("GUI_LOCATION_WIDTH", 0L));
                note.setHeight((int)r.getInteger("GUI_LOCATION_HEIGHT", 0L));
                note.setSelected(false);
                note.setFontName(r.getString("FONT_NAME", null));
                note.setFontSize((int)r.getInteger("FONT_SIZE", -1L));
                note.setFontBold(r.getBoolean("FONT_BOLD", false));
                note.setFontItalic(r.getBoolean("FONT_ITALIC", false));
                note.setFontColorRed((int)r.getInteger("FONT_COLOR_RED", 0L));
                note.setFontColorGreen((int)r.getInteger("FONT_COLOR_GREEN", 0L));
                note.setFontColorBlue((int)r.getInteger("FONT_COLOR_BLUE", 0L));
                note.setBackGroundColorRed((int)r.getInteger("FONT_BACK_GROUND_COLOR_RED", 255L));
                note.setBackGroundColorGreen((int)r.getInteger("FONT_BACK_GROUND_COLOR_GREEN", 205L));
                note.setBackGroundColorBlue((int)r.getInteger("FONT_BACK_GROUND_COLOR_BLUE", 112L));
                note.setBorderColorRed((int)r.getInteger("FONT_BORDER_COLOR_RED", 100L));
                note.setBorderColorGreen((int)r.getInteger("FONT_BORDER_COLOR_GREEN", 100L));
                note.setBorderColorBlue((int)r.getInteger("FONT_BORDER_COLOR_BLUE", 100L));
                note.setDrawShadow(r.getBoolean("DRAW_SHADOW", true));
                return note;
            }
            note.setObjectId(null);
            throw new KettleException("I couldn't find Notepad with id_note=" + id_note + " in the repository.");
        }
        catch (KettleDatabaseException dbe) {
            note.setObjectId(null);
            throw new KettleException("Unable to load Notepad from repository (id_note=" + id_note + ")", (Throwable)dbe);
        }
    }

    public void saveNotePadMeta(NotePadMeta note, ObjectId id_transformation) throws KettleException {
        try {
            Point location = note.getLocation();
            int x = location == null ? -1 : location.x;
            int y = location == null ? -1 : location.y;
            note.setObjectId(this.insertNote(note.getNote(), x, y, note.getWidth(), note.getHeight(), note.getFontName(), note.getFontSize(), note.isFontBold(), note.isFontItalic(), note.getFontColorRed(), note.getFontColorGreen(), note.getFontColorBlue(), note.getBackGroundColorRed(), note.getBackGroundColorGreen(), note.getBackGroundColorBlue(), note.getBorderColorRed(), note.getBorderColorGreen(), note.getBorderColorBlue(), note.isDrawShadow()));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save notepad in repository (id_transformation=" + id_transformation + ")", (Throwable)dbe);
        }
    }

    public synchronized ObjectId insertNote(String note, long gui_location_x, long gui_location_y, long gui_location_width, long gui_location_height, String fontname, long fontsize, boolean fontbold, boolean fontitalic, long fontcolorred, long fontcolorgreen, long fontcolorblue, long fontbackcolorred, long fontbackcolorgreen, long fontbackcolorblue, long fontbordercolorred, long fontbordercolorgreen, long fontbordercolorblue, boolean drawshadow) throws KettleException {
        ObjectId id = this.repository.connectionDelegate.getNextNoteID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMeta("ID_NOTE", 5), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMeta("VALUE_STR", 2), (Object)note);
        table.addValue((ValueMetaInterface)new ValueMeta("GUI_LOCATION_X", 5), (Object)new Long(gui_location_x));
        table.addValue((ValueMetaInterface)new ValueMeta("GUI_LOCATION_Y", 5), (Object)new Long(gui_location_y));
        table.addValue((ValueMetaInterface)new ValueMeta("GUI_LOCATION_WIDTH", 5), (Object)new Long(gui_location_width));
        table.addValue((ValueMetaInterface)new ValueMeta("GUI_LOCATION_HEIGHT", 5), (Object)new Long(gui_location_height));
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_NAME", 2), (Object)fontname);
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_SIZE", 5), (Object)fontsize);
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_BOLD", 4), (Object)fontbold);
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_ITALIC", 4), (Object)fontitalic);
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_COLOR_RED", 5), (Object)new Long(fontcolorred));
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_COLOR_GREEN", 5), (Object)new Long(fontcolorgreen));
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_COLOR_BLUE", 5), (Object)new Long(fontcolorblue));
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_BACK_GROUND_COLOR_RED", 5), (Object)new Long(fontbackcolorred));
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_BACK_GROUND_COLOR_GREEN", 5), (Object)new Long(fontbackcolorgreen));
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_BACK_GROUND_COLOR_BLUE", 5), (Object)new Long(fontbackcolorblue));
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_BORDER_COLOR_RED", 5), (Object)new Long(fontbordercolorred));
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_BORDER_COLOR_GREEN", 5), (Object)new Long(fontbordercolorgreen));
        table.addValue((ValueMetaInterface)new ValueMeta("FONT_BORDER_COLOR_BLUE", 5), (Object)new Long(fontbordercolorblue));
        table.addValue((ValueMetaInterface)new ValueMeta("DRAW_SHADOW", 4), (Object)drawshadow);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_NOTE");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }
}

