/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.pgpencryptfiles;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.pgpencryptfiles.JobEntryPGPEncryptFiles;

public class GPG {
    private static Class<?> PKG = JobEntryPGPEncryptFiles.class;
    private LogChannelInterface log;
    private final String gnuPGCommand = "--batch --armor ";
    private String gpgexe = "/usr/local/bin/gpg";
    private File tmpFile;

    public GPG(String gpgFilename, LogChannelInterface logInterface) throws KettleException {
        this.log = logInterface;
        this.gpgexe = gpgFilename;
        if (Const.isEmpty((String)this.getGpgExeFile())) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPG.GPGFilenameMissing", (String[])new String[0]));
        }
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject((String)this.getGpgExeFile());
            if (!file.exists()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPG.GPGFilenameNotFound", (String[])new String[0]));
            }
            if (!file.getType().equals((Object)FileType.FILE)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPG.GPGNotAFile", (String[])new String[]{this.getGpgExeFile()}));
            }
            this.gpgexe = KettleVFS.getFilename((FileObject)file);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPG.ErrorCheckingGPGFile", (String[])new String[]{this.getGpgExeFile()}), (Throwable)e);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public String getGpgExeFile() {
        return this.gpgexe;
    }

    private String execGnuPG(String commandArgs, String inputStr, boolean fileMode) throws KettleException {
        Process p;
        String command = this.getGpgExeFile() + " " + (fileMode ? "" : "--batch --armor  ") + commandArgs;
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"GPG.RunningCommand", (String[])new String[]{command}));
        }
        try {
            if (Const.isWindows()) {
                p = Runtime.getRuntime().exec(command);
            } else {
                ProcessBuilder processBuilder = new ProcessBuilder("/bin/sh", "-c", command);
                p = processBuilder.start();
            }
        }
        catch (IOException io) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPG.IOException", (String[])new String[0]), (Throwable)io);
        }
        ProcessStreamReader psr_stdout = new ProcessStreamReader(p.getInputStream());
        ProcessStreamReader psr_stderr = new ProcessStreamReader(p.getErrorStream());
        psr_stdout.start();
        psr_stderr.start();
        if (inputStr != null) {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()));
            try {
                out.write(inputStr);
            }
            catch (IOException io) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPG.ExceptionWrite", (String[])new String[0]), (Throwable)io);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        try {
            p.waitFor();
            psr_stdout.join();
            psr_stderr.join();
        }
        catch (InterruptedException i) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPG.ExceptionWait", (String[])new String[0]), (Throwable)i);
        }
        try {
            if (p.exitValue() != 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPG.Exception.ExistStatus", (String[])new String[]{psr_stderr.getString()}));
            }
        }
        catch (IllegalThreadStateException itse) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPG.ExceptionillegalThreadStateException", (String[])new String[0]), (Throwable)itse);
        }
        finally {
            p.destroy();
        }
        String retval = psr_stdout.getString();
        return retval;
    }

    public void decryptFile(FileObject cryptedFilename, String passPhrase, FileObject decryptedFilename) throws KettleException {
        this.decryptFile(KettleVFS.getFilename((FileObject)cryptedFilename), passPhrase, KettleVFS.getFilename((FileObject)decryptedFilename));
    }

    public void decryptFile(String cryptedFilename, String passPhrase, String decryptedFilename) throws KettleException {
        try {
            this.execGnuPG("--batch --yes " + (Const.isEmpty((String)passPhrase) ? "" : "--passphrase \"" + passPhrase + "\" ") + "--output " + "\"" + decryptedFilename + "\" " + "--decrypt " + "\"" + cryptedFilename + "\"", null, true);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void encryptFile(FileObject filename, String userID, FileObject cryptedFilename, boolean asciiMode) throws KettleException {
        this.encryptFile(KettleVFS.getFilename((FileObject)filename), userID, KettleVFS.getFilename((FileObject)cryptedFilename), asciiMode);
    }

    public void encryptFile(String filename, String userID, String cryptedFilename, boolean asciiMode) throws KettleException {
        try {
            this.execGnuPG("--batch --yes" + (asciiMode ? " -a" : "") + " -r " + "\"" + Const.NVL((String)userID, (String)"") + "\" " + "--output " + "\"" + cryptedFilename + "\" " + "--encrypt  " + "\"" + filename + "\"", null, true);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void signAndEncryptFile(FileObject file, String userID, FileObject cryptedFile, boolean asciiMode) throws KettleException {
        this.signAndEncryptFile(KettleVFS.getFilename((FileObject)file), userID, KettleVFS.getFilename((FileObject)cryptedFile), asciiMode);
    }

    public void signAndEncryptFile(String filename, String userID, String cryptedFilename, boolean asciiMode) throws KettleException {
        try {
            this.execGnuPG("--batch --yes" + (asciiMode ? " -a" : "") + (Const.isEmpty((String)userID) ? "" : " -r \"" + userID + "\"") + " " + "--output " + "\"" + cryptedFilename + "\" " + "--encrypt --sign " + "\"" + filename + "\"", null, true);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void signFile(String filename, String userID, String signedFilename, boolean asciiMode) throws KettleException {
        try {
            this.execGnuPG("--batch --yes" + (asciiMode ? " -a" : "") + (Const.isEmpty((String)userID) ? "" : " -r \"" + userID + "\"") + " " + "--output " + "\"" + signedFilename + "\" " + (asciiMode ? "--clearsign " : "--sign ") + "\"" + filename + "\"", null, true);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void signFile(FileObject file, String userID, FileObject signedFile, boolean asciiMode) throws KettleException {
        try {
            this.signFile(KettleVFS.getFilename((FileObject)file), userID, KettleVFS.getFilename((FileObject)signedFile), asciiMode);
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void verifySignature(FileObject filename) throws KettleException {
        this.verifySignature(KettleVFS.getFilename((FileObject)filename));
    }

    public void verifySignature(String filename) throws KettleException {
        this.execGnuPG("--batch --verify \"" + filename + "\"", null, true);
    }

    public void verifyDetachedSignature(String signatureFilename, String originalFilename) throws KettleException {
        this.execGnuPG("--batch --verify \"" + signatureFilename + "\" " + "\"" + originalFilename + "\"", null, true);
    }

    public void verifyDetachedSignature(FileObject signatureFile, FileObject originalFile) throws KettleException {
        this.verifyDetachedSignature(KettleVFS.getFilename((FileObject)signatureFile), KettleVFS.getFilename((FileObject)originalFile));
    }

    public String encrypt(String plainText, String keyID) throws KettleException {
        return this.execGnuPG("-r \"" + keyID + "\" --encrypt ", plainText, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String signAndEncrypt(String plainText, String userID, String passPhrase) throws KettleException {
        try {
            this.createTempFile(plainText);
            String string = this.execGnuPG("-r \"" + userID + "\" --passphrase-fd 0 -se \"" + this.getTempFileName() + "\"", passPhrase, false);
            return string;
        }
        finally {
            this.deleteTempFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sign(String stringToSign, String passPhrase) throws KettleException {
        String retval;
        try {
            this.createTempFile(stringToSign);
            retval = this.execGnuPG("--passphrase-fd 0 --sign \"" + this.getTempFileName() + "\"", passPhrase, false);
        }
        finally {
            this.deleteTempFile();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decrypt(String cryptedText, String passPhrase) throws KettleException {
        try {
            this.createTempFile(cryptedText);
            String string = this.execGnuPG("--passphrase-fd 0 --decrypt \"" + this.getTempFileName() + "\"", passPhrase, false);
            return string;
        }
        finally {
            this.deleteTempFile();
        }
    }

    private void createTempFile(String content) throws KettleException {
        this.tmpFile = null;
        try {
            this.tmpFile = File.createTempFile("GnuPG", null);
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"GPG.TempFileCreated", (String[])new String[]{this.getTempFileName()}));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPG.ErrorCreatingTempFile", (String[])new String[0]), (Throwable)e);
        }
        try {
            FileWriter fw = new FileWriter(this.tmpFile);
            fw.write(content);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            this.deleteTempFile();
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPG.ErrorWritingTempFile", (String[])new String[0]), (Throwable)e);
        }
    }

    private void deleteTempFile() {
        if (this.tmpFile != null) {
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"GPG.DeletingTempFile", (String[])new String[]{this.getTempFileName()}));
            }
            this.tmpFile.delete();
        }
    }

    private String getTempFileName() {
        return this.tmpFile.getAbsolutePath();
    }

    public String toString() {
        return "GPG";
    }

    class ProcessStreamReader
    extends Thread {
        StringBuffer stream;
        InputStreamReader in;
        static final int BUFFER_SIZE = 1024;

        ProcessStreamReader(InputStream in) {
            this.in = new InputStreamReader(in);
            this.stream = new StringBuffer();
        }

        @Override
        public void run() {
            try {
                int read;
                char[] c = new char[1024];
                while ((read = this.in.read(c, 0, 1023)) > 0) {
                    this.stream.append(c, 0, read);
                    if (read >= 1023) continue;
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getString() {
            return this.stream.toString();
        }
    }
}

