/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.connectedtorepository;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryConnectedToRepository
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryConnectedToRepository.class;
    private boolean isspecificrep = false;
    private String repname = null;
    private boolean isspecificuser = false;
    private String username = null;

    public JobEntryConnectedToRepository(String n, String scr) {
        super(n, "");
    }

    public JobEntryConnectedToRepository() {
        this("", "");
    }

    public void setSpecificRep(boolean isspecificrep) {
        this.isspecificrep = isspecificrep;
    }

    public String getRepName() {
        return this.repname;
    }

    public void setRepName(String repname) {
        this.repname = repname;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public boolean isSpecificRep() {
        return this.isspecificrep;
    }

    public boolean isSpecificUser() {
        return this.isspecificuser;
    }

    public void setSpecificUser(boolean isspecificuser) {
        this.isspecificuser = isspecificuser;
    }

    @Override
    public Object clone() {
        JobEntryConnectedToRepository je = (JobEntryConnectedToRepository)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("      ").append(XMLHandler.addTagValue((String)"isspecificrep", (boolean)this.isspecificrep));
        retval.append("      ").append(XMLHandler.addTagValue((String)"repname", (String)this.repname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isspecificuser", (boolean)this.isspecificuser));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append(super.getXML());
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.isspecificrep = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"isspecificrep"));
            this.repname = XMLHandler.getTagValue((Node)entrynode, (String)"repname");
            this.isspecificuser = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"isspecificuser"));
            this.username = XMLHandler.getTagValue((Node)entrynode, (String)"username");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepository.Meta.UnableToLoadFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.isspecificrep = rep.getJobEntryAttributeBoolean(id_jobentry, "isspecificrep");
            this.repname = rep.getJobEntryAttributeString(id_jobentry, "repname");
            this.isspecificuser = rep.getJobEntryAttributeBoolean(id_jobentry, "isspecificuser");
            this.username = rep.getJobEntryAttributeString(id_jobentry, "username");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepository.Meta.UnableToLoadFromRep", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "isspecificrep", this.isspecificrep);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "repname", this.repname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "isspecificuser", this.isspecificuser);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.username);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepository.Meta.UnableToSaveToRep", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        if (this.rep == null) {
            this.logError(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepository.Log.NotConnected", (String[])new String[0]));
            return result;
        }
        if (this.isspecificrep) {
            if (Const.isEmpty((String)this.repname)) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepository.Error.NoRep", (String[])new String[0]));
                return result;
            }
            String Reponame = this.environmentSubstitute(this.repname);
            if (!Reponame.equals(this.rep.getName())) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepository.Error.DiffRep", (String[])new String[]{this.rep.getName(), Reponame}));
                return result;
            }
        }
        if (this.isspecificuser) {
            if (Const.isEmpty((String)this.username)) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepository.Error.NoUser", (String[])new String[0]));
                return result;
            }
            String realUsername = this.environmentSubstitute(this.username);
            if (this.rep.getSecurityProvider().getUserInfo() != null && !realUsername.equals(this.rep.getSecurityProvider().getUserInfo().getLogin())) {
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepository.Error.DiffUser", (String[])new String[]{this.rep.getUserInfo().getLogin(), realUsername}));
                return result;
            }
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepository.Log.Connected", (String[])new String[]{this.rep.getName(), this.rep.getUserInfo() != null ? this.rep.getUserInfo().getLogin() : ""}));
        }
        result.setResult(true);
        result.setNrErrors(0L);
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }
}

