/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.util.prefs.Preferences;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.KeyValue;
import org.pentaho.di.core.util.PluginProperty;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class IntegerPluginProperty
extends KeyValue<Integer>
implements PluginProperty {
    private static final long serialVersionUID = -2990345692552430357L;

    public IntegerPluginProperty(String key) throws IllegalArgumentException {
        super(key, DEFAULT_INTEGER_VALUE);
    }

    @Override
    public boolean evaluate() {
        Integer value = (Integer)this.getValue();
        return value != null && value != 0;
    }

    @Override
    public void appendXml(StringBuilder builder) {
        builder.append(XMLHandler.addTagValue((String)this.getKey(), (int)((Integer)this.getValue())));
    }

    @Override
    public void loadXml(Node node) {
        Integer value = Integer.parseInt(XMLHandler.getTagValue((Node)node, (String)this.getKey()));
        this.setValue(value);
    }

    @Override
    public void readFromRepositoryStep(Repository repository, IMetaStore metaStore, ObjectId stepId) throws KettleException {
        Long longValue = repository.getStepAttributeInteger(stepId, this.getKey());
        this.setValue(longValue.intValue());
    }

    @Override
    public void saveToPreferences(Preferences node) {
        node.putInt(this.getKey(), (Integer)this.getValue());
    }

    @Override
    public void readFromPreferences(Preferences node) {
        this.setValue(node.getInt(this.getKey(), (Integer)this.getValue()));
    }

    @Override
    public void saveToRepositoryStep(Repository repository, IMetaStore metaStore, ObjectId transformationId, ObjectId stepId) throws KettleException {
        repository.saveStepAttribute(transformationId, stepId, this.getKey(), ((Integer)this.getValue()).intValue());
    }
}

