/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogTablePlugin;
import org.pentaho.di.core.logging.LogTablePluginInterface;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginMainClassType(value=LogTablePluginInterface.class)
@PluginAnnotationType(value=LogTablePlugin.class)
public class LogTablePluginType
extends BasePluginType
implements PluginTypeInterface {
    private static LogTablePluginType logTablePluginType;

    private LogTablePluginType() {
        super(LogTablePlugin.class, "LOGTABLE", "Log table plugin");
        this.populateFolders("logtable");
    }

    public static LogTablePluginType getInstance() {
        if (logTablePluginType == null) {
            logTablePluginType = new LogTablePluginType();
        }
        return logTablePluginType;
    }

    protected void registerNatives() throws KettlePluginException {
    }

    protected void registerXmlPlugins() throws KettlePluginException {
        for (PluginFolderInterface folder : this.pluginFolders) {
            if (!folder.isPluginXmlFolder()) continue;
            List pluginXmlFiles = this.findPluginXmlFiles(folder.getFolder());
            for (FileObject file : pluginXmlFiles) {
                try {
                    Document document = XMLHandler.loadXMLFile((FileObject)file);
                    Node pluginNode = XMLHandler.getSubNode((Node)document, (String)"plugin");
                    if (pluginNode == null) continue;
                    this.registerPluginFromXmlResource(pluginNode, KettleVFS.getFilename((FileObject)file.getParent()), ((Object)((Object)this)).getClass(), false, file.getParent().getURL());
                }
                catch (Exception e) {
                    this.log.logError("Error found while reading logging plugin.xml file: " + file.getName().toString(), (Throwable)e);
                }
            }
        }
    }

    protected String extractCategory(Annotation annotation) {
        return null;
    }

    protected String extractDesc(Annotation annotation) {
        return null;
    }

    protected String extractID(Annotation annotation) {
        String id = ((LogTablePlugin)annotation).id();
        LogChannel.GENERAL.logBasic("Logging plugin type found with ID: " + id);
        return id;
    }

    protected String extractName(Annotation annotation) {
        return null;
    }

    protected String extractImageFile(Annotation annotation) {
        return null;
    }

    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return false;
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return null;
    }

    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    protected String extractDocumentationUrl(Annotation annotation) {
        return null;
    }

    protected String extractCasesUrl(Annotation annotation) {
        return null;
    }

    protected String extractForumUrl(Annotation annotation) {
        return null;
    }

    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((LogTablePlugin)annotation).classLoaderGroup();
    }
}

