/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.compress.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.compress.CompressionOutputStream;
import org.pentaho.di.core.compress.CompressionProvider;

public class ZIPCompressionOutputStream
extends CompressionOutputStream {
    public ZIPCompressionOutputStream(OutputStream out, CompressionProvider provider) {
        super(ZIPCompressionOutputStream.getDelegate(out), provider);
    }

    protected static ZipOutputStream getDelegate(OutputStream out) {
        ZipOutputStream delegate = out instanceof ZipOutputStream ? (ZipOutputStream)out : new ZipOutputStream(out);
        return delegate;
    }

    @Override
    public void close() throws IOException {
        ZipOutputStream zos = (ZipOutputStream)this.delegate;
        zos.flush();
        zos.closeEntry();
        zos.finish();
        zos.close();
    }

    @Override
    public void addEntry(String filename, String extension) throws IOException {
        int index = filename.lastIndexOf(Const.FILE_SEPARATOR);
        String entryPath = index != -1 ? filename.substring(index + 1) : filename;
        index = entryPath.toLowerCase().lastIndexOf(".zip");
        if (index != -1) {
            entryPath = entryPath.substring(0, index) + entryPath.substring(index + ".zip".length());
        }
        if (!Const.isEmpty((String)extension)) {
            entryPath = entryPath + "." + extension;
        }
        ZipEntry zipentry = new ZipEntry(entryPath);
        zipentry.setComment("Compressed by Kettle");
        ((ZipOutputStream)this.delegate).putNextEntry(zipentry);
    }
}

