/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.lang.annotation.Annotation;
import org.pentaho.di.core.plugins.BasePluginType;

public class BasePluginTypeExposer {
    private BasePluginType pluginType;
    private Object target;
    private String packageName;
    private final String altPackageName;

    public BasePluginTypeExposer(BasePluginType pluginType, Object target) {
        this.target = target;
        this.pluginType = pluginType;
        this.altPackageName = target.getClass().getPackage().getName();
    }

    public String extractID(Annotation annotation) {
        return this.pluginType.extractID(annotation);
    }

    public String extractName(Annotation annotation) {
        String name = this.pluginType.extractName(annotation);
        this.packageName = this.extractI18nPackageName(annotation);
        return BasePluginType.getTranslation(name, this.packageName, this.altPackageName, this.target.getClass());
    }

    public String extractDesc(Annotation annotation) {
        String desc = this.pluginType.extractDesc(annotation);
        this.packageName = this.extractI18nPackageName(annotation);
        return BasePluginType.getTranslation(desc, this.packageName, this.altPackageName, this.target.getClass());
    }

    public String extractCategory(Annotation annotation) {
        String category = this.pluginType.extractCategory(annotation);
        this.packageName = this.extractI18nPackageName(annotation);
        return BasePluginType.getTranslation(category, this.packageName, this.altPackageName, this.target.getClass());
    }

    public String extractImageFile(Annotation annotation) {
        return this.pluginType.extractImageFile(annotation);
    }

    public boolean extractSeparateClassLoader(Annotation annotation) {
        return this.pluginType.extractSeparateClassLoader(annotation);
    }

    public String extractI18nPackageName(Annotation annotation) {
        return this.pluginType.extractI18nPackageName(annotation);
    }

    public String extractDocumentationUrl(Annotation annotation) {
        return this.pluginType.extractDocumentationUrl(annotation);
    }

    public String extractCasesUrl(Annotation annotation) {
        return this.pluginType.extractCasesUrl(annotation);
    }

    public String extractForumUrl(Annotation annotation) {
        return this.pluginType.extractForumUrl(annotation);
    }
}

