/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.pentaho.di.cluster.HttpUtil;
import org.pentaho.di.core.jdbc.ThinConnection;
import org.pentaho.di.core.jdbc.ThinResultSet;
import org.pentaho.di.core.variables.Variables;

@Deprecated
public class ThinStatement
implements Statement {
    protected ThinConnection connection;
    protected ThinResultSet resultSet;
    protected int maxRows;

    public ThinStatement(ThinConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection);
    }

    public ThinStatement(ThinConnection connection, int rsType, int rsConcurrency, int rsHoldability) {
        this(connection);
    }

    public ThinStatement(ThinConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.cancel();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLException("Batch update statements are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, 0);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    @Override
    public boolean execute(String sql, int[] arg1) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    @Override
    public boolean execute(String sql, String[] arg1) throws SQLException {
        return this.executeQuery(sql) != null;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException("Batch update statements are not supported by the thin Kettle JDBC driver");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            String url = HttpUtil.constructUrl(new Variables(), this.connection.getHostname(), this.connection.getPort(), this.connection.getWebAppName(), this.connection.getService() + "/sql/");
            this.resultSet = new ThinResultSet(this, url, this.connection.getUsername(), this.connection.getPassword(), sql);
            return this.resultSet;
        }
        catch (Exception e) {
            throw new SQLException("Unable to execute query: ", e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("The thin Kettle JDBC driver is read-only");
    }

    @Override
    public int executeUpdate(String sql, int arg1) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, int[] arg1) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] arg1) throws SQLException {
        return this.executeUpdate(sql);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 1;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("The thin Kettle JDBC driver is read-only");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.resultSet == null) {
            throw new SQLException("Statement is closed.");
        }
        if (this.resultSet.isLast() || this.resultSet.isClosed()) {
            this.resultSet.close();
            return false;
        }
        return true;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        if (current != 1) {
            throw new SQLFeatureNotSupportedException("Multiple open result sets not supported");
        }
        return this.getMoreResults();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.resultSet.getConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.resultSet.getHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.resultSet.getType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.resultSet.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }
}

