/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.extension;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginMainClassType(value=ExtensionPointInterface.class)
@PluginAnnotationType(value=ExtensionPoint.class)
public class ExtensionPointPluginType
extends BasePluginType
implements PluginTypeInterface {
    private static ExtensionPointPluginType pluginType;

    private ExtensionPointPluginType() {
        super(ExtensionPoint.class, "EXTENSION_POINT", "Extension point");
        this.populateFolders("extension_points");
    }

    public static ExtensionPointPluginType getInstance() {
        if (pluginType == null) {
            pluginType = new ExtensionPointPluginType();
        }
        return pluginType;
    }

    @Override
    protected void registerNatives() throws KettlePluginException {
        String xmlFile = "kettle-extension-points.xml";
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(xmlFile);
            if (inputStream == null) {
                inputStream = this.getClass().getResourceAsStream("/" + xmlFile);
            }
            if (inputStream == null) {
                throw new KettlePluginException("Unable to find native kettle database types definition file: " + xmlFile);
            }
            Document document = XMLHandler.loadXMLFile(inputStream, null, true, false);
            Node repsNode = XMLHandler.getSubNode(document, "extension-points");
            List<Node> repsNodes = XMLHandler.getNodes(repsNode, "extension-point");
            for (Node repNode : repsNodes) {
                this.registerPluginFromXmlResource(repNode, "./", this.getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle extension points XML config file: " + xmlFile, e);
        }
    }

    @Override
    protected void registerXmlPlugins() throws KettlePluginException {
    }

    @Override
    public void handlePluginAnnotation(Class<?> clazz, Annotation annotation, List<String> libraries, boolean nativePluginType, URL pluginFolder) throws KettlePluginException {
        super.handlePluginAnnotation(clazz, annotation, libraries, nativePluginType, pluginFolder);
    }

    public String[] getNaturalCategoriesOrder() {
        return new String[0];
    }

    @Override
    protected String extractCategory(Annotation annotation) {
        return "";
    }

    @Override
    protected String extractDesc(Annotation annotation) {
        return ((ExtensionPoint)annotation).description();
    }

    @Override
    protected String extractID(Annotation annotation) {
        return ((ExtensionPoint)annotation).id();
    }

    @Override
    protected String extractName(Annotation annotation) {
        return ((ExtensionPoint)annotation).extensionPointId();
    }

    @Override
    protected String extractImageFile(Annotation annotation) {
        return null;
    }

    @Override
    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return false;
    }

    @Override
    protected String extractI18nPackageName(Annotation annotation) {
        return null;
    }

    @Override
    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    @Override
    protected String extractDocumentationUrl(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractCasesUrl(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractForumUrl(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((ExtensionPoint)annotation).classLoaderGroup();
    }
}

