/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.pentaho.di.core.Const;

public class WriterOutputStream
extends OutputStream {
    private Writer writer;
    private String encoding;

    public WriterOutputStream(Writer writer) {
        this.writer = writer;
    }

    public WriterOutputStream(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] buf = new byte[len];
        System.arraycopy(b, off, buf, 0, len);
        this.write(buf);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (Const.isEmpty(this.encoding)) {
            this.writer.append(new String(b));
        } else {
            this.writer.append(new String(b, this.encoding));
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.writer = null;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

