/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.testdocs;

import java.io.File;
import java.io.IOException;
import org.jfor.jfor.main.JForVersionInfo;
import org.jfor.jfor.rtflib.testdocs.TestDocument;

public class CreateTestDocuments {
    public static final String TESTDOCS_PACKAGE = "org.jfor.jfor.rtflib.testdocs";
    private static final String[] classNames = new String[]{"SimpleDocument", "TextAttributes", "SimpleTable", "SimpleLists", "ListInTable", "Whitespace", "MergedTableCells", "NestedTable", "ExternalGraphic", "BasicLink", "ParagraphAlignment"};

    CreateTestDocuments(File file) throws Exception {
        if (!file.isDirectory() || !file.canWrite()) {
            throw new IOException("output directory (" + file + ") must exist and be writable");
        }
        int n = 0;
        while (n < classNames.length) {
            this.createOneTestDocument(classNames[n], file);
            ++n;
        }
    }

    void createOneTestDocument(String string, File file) throws Exception {
        string = "org.jfor.jfor.rtflib.testdocs." + string;
        TestDocument testDocument = null;
        try {
            testDocument = (TestDocument)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new Exception("unable to instantiate '" + string + " as a TestDocument object: " + exception);
        }
        testDocument.setOutputDir(file);
        testDocument.generateOutput();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("usage: CreateTestDocuments <output directory>");
            System.exit(1);
        }
        System.err.println("CreateTestDocuments - using " + JForVersionInfo.getLongVersionInfo());
        System.err.println("Generates documents to test the jfor RTF library.");
        File file = new File(stringArray[0]);
        new CreateTestDocuments(file);
        System.err.println("CreateTestDocuments - all done.");
        System.exit(0);
    }
}

