/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class RtfStringConverter {
    private static final RtfStringConverter m_instance = new RtfStringConverter();
    private static final Map m_specialChars;
    private static final Character DBLQUOTE;
    private static final Character QUOTE;
    private static final Character SPACE;

    private RtfStringConverter() {
    }

    public static RtfStringConverter getInstance() {
        return m_instance;
    }

    public void writeRtfString(Writer writer, String string) throws IOException {
        if (string == null) {
            return;
        }
        int n = 0;
        while (n < string.length()) {
            Character c = new Character(string.charAt(n));
            Character c2 = n != 0 ? new Character(string.charAt(n - 1)) : new Character(string.charAt(n));
            String string2 = c.equals(DBLQUOTE) && c2.equals(SPACE) ? "ldblquote" : (c.equals(QUOTE) && c2.equals(SPACE) ? "lquote" : (String)m_specialChars.get(c));
            if (string2 != null) {
                writer.write(92);
                writer.write(string2);
                writer.write(32);
            } else if (c.charValue() > '\u00ff') {
                writer.write("\\u");
                writer.write(Integer.toString(c.charValue()));
                writer.write("\\'3f");
            } else {
                writer.write(c.charValue());
            }
            ++n;
        }
    }

    static {
        DBLQUOTE = new Character('\"');
        QUOTE = new Character('\'');
        SPACE = new Character(' ');
        m_specialChars = new HashMap();
        m_specialChars.put(new Character('\t'), "tab");
        m_specialChars.put(new Character('\n'), "line");
        m_specialChars.put(new Character('\''), "rquote");
        m_specialChars.put(new Character('\"'), "rdblquote");
        m_specialChars.put(new Character('\\'), "\\");
        m_specialChars.put(new Character('{'), "{");
        m_specialChars.put(new Character('}'), "}");
    }
}

