/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.barbecue;

import net.sf.jasperreports.components.barbecue.BarbecueComponent;
import net.sf.jasperreports.components.barbecue.StandardBarbecueComponent;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class BarbecueCompiler
implements ComponentCompiler {
    @Override
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        BarbecueComponent barcode = (BarbecueComponent)component;
        collector.addExpression(barcode.getCodeExpression());
        collector.addExpression(barcode.getApplicationIdentifierExpression());
    }

    @Override
    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        BarbecueComponent barcode = (BarbecueComponent)component;
        return new StandardBarbecueComponent(barcode, baseFactory);
    }

    @Override
    public void verify(Component component, JRVerifier verifier) {
        EvaluationTimeEnum evaluationTime;
        JRExpression codeExpression;
        BarbecueComponent barcode = (BarbecueComponent)component;
        String type = barcode.getType();
        if (type == null) {
            verifier.addBrokenRule("No barcode type set", (Object)barcode);
        }
        if ((codeExpression = barcode.getCodeExpression()) == null) {
            verifier.addBrokenRule("Barcode expression is null", (Object)barcode);
        }
        if ((evaluationTime = barcode.getEvaluationTimeValue()) == EvaluationTimeEnum.AUTO) {
            verifier.addBrokenRule("Auto evaluation time is not supported for barcodes", (Object)barcode);
        } else if (evaluationTime == EvaluationTimeEnum.GROUP) {
            String evaluationGroup = barcode.getEvaluationGroup();
            if (evaluationGroup == null || evaluationGroup.length() == 0) {
                verifier.addBrokenRule("No evaluation group set for barcode", (Object)barcode);
            } else if (!verifier.getReportDesign().getGroupsMap().containsKey(evaluationGroup)) {
                verifier.addBrokenRule("Barcode evaluation group \"" + evaluationGroup + " not found", (Object)barcode);
            }
        }
    }
}

