/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.compilers.ReportClassWhitelist;

public class StandardReportClassWhitelist
implements ReportClassWhitelist {
    public static final String WHITELIST_SEPARATOR = ",";
    private static final String WHITELIST_SEPARATOR_PATTERN = Pattern.quote(",");
    private static final char WILDCARD = '*';
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("\\*+");
    private Set<String> classWhitelist = new HashSet<String>();
    private List<Pattern> whitelistPatterns = new ArrayList<Pattern>();

    @Override
    public boolean includesClass(String className) {
        if (this.classWhitelist.contains(className)) {
            return true;
        }
        if (!this.whitelistPatterns.isEmpty()) {
            for (Pattern pattern : this.whitelistPatterns) {
                if (!pattern.matcher(className).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void addClass(String className) {
        this.classWhitelist.add(className);
    }

    public void addWhitelist(String whitelist) {
        String[] classes;
        for (String whitelistClass : classes = whitelist.split(WHITELIST_SEPARATOR_PATTERN)) {
            if ((whitelistClass = whitelistClass.trim()).isEmpty()) continue;
            if (whitelistClass.indexOf(42) >= 0) {
                this.addPattern(whitelistClass);
            }
            this.classWhitelist.add(whitelistClass);
        }
    }

    protected void addPattern(String classWildcard) {
        Matcher matcher = WILDCARD_PATTERN.matcher(classWildcard);
        StringBuilder patternStr = new StringBuilder();
        int prevIndex = 0;
        while (matcher.find()) {
            int matchStart = matcher.start();
            int matchEnd = matcher.end();
            if (matchStart > prevIndex) {
                patternStr.append(Pattern.quote(classWildcard.substring(prevIndex, matchStart)));
            }
            if (matchStart + 1 == matchEnd) {
                patternStr.append("[^\\.]*");
            } else {
                patternStr.append(".*");
            }
            prevIndex = matchEnd;
        }
        if (prevIndex < classWildcard.length()) {
            patternStr.append(Pattern.quote(classWildcard.substring(prevIndex, classWildcard.length())));
        }
        Pattern pattern = Pattern.compile(patternStr.toString());
        this.whitelistPatterns.add(pattern);
    }
}

