/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

import com.github.kklisura.cdt.launch.ChromeArguments;
import com.github.kklisura.cdt.launch.ChromeLauncher;
import com.github.kklisura.cdt.services.ChromeService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.sf.jasperreports.chrome.ChromeArgumentsBuilder;
import net.sf.jasperreports.chrome.ChromeInstanceHandle;
import net.sf.jasperreports.chrome.ChromeInstanceState;
import net.sf.jasperreports.chrome.LaunchConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChromeInstance
implements ChromeInstanceHandle {
    private static final Log log = LogFactory.getLog(ChromeInstance.class);
    private static final AtomicLong ID_SEQ = new AtomicLong();
    private final long id = ID_SEQ.incrementAndGet();
    private LaunchConfiguration configuration;
    private ChromeLauncher launcher;
    private ChromeService chromeService;
    private volatile ChromeInstanceState state;

    public ChromeInstance(LaunchConfiguration configuration) {
        this.configuration = configuration;
        this.state = ChromeInstanceState.create();
    }

    public long getId() {
        return this.id;
    }

    public void start() {
        this.launcher = new ChromeLauncher();
        ChromeArguments args = ChromeArgumentsBuilder.instance().toArguments(this.configuration);
        log.info((Object)("Launching Chrome instance " + this.id + " with configuration " + this.configuration));
        this.chromeService = this.launcher.launch(this.configuration.getExecutablePath(), args);
    }

    public boolean isAlive() {
        return this.launcher != null && this.launcher.isAlive();
    }

    @Override
    public <T> T runWithChromeInstance(Function<ChromeService, T> execution) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("using chrome instance " + this.id));
        }
        this.startUse();
        try {
            T t = execution.apply(this.chromeService);
            return t;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ending use of chrome instance " + this.id));
            }
            this.endUse();
        }
    }

    protected synchronized void startUse() {
        this.state = this.state.incrementUse();
    }

    protected synchronized void endUse() {
        this.state = this.state.decrementUse();
        if (this.state.shouldClose()) {
            this.doClose();
        }
    }

    public synchronized ChromeInstanceState getState() {
        return this.state;
    }

    public synchronized void close() {
        if (!this.state.isClosed()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("closing " + this.id));
            }
            this.state = this.state.close();
            if (this.state.shouldClose()) {
                this.doClose();
            }
        }
    }

    protected void doClose() {
        log.info((Object)("Shutting down Chrome instance " + this.id));
        this.launcher.close();
    }
}

