/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.lob;

import com.informix.util.IfxErrMsg;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class IfxImmutableClob
implements Clob {
    private final String value;
    private final String encoding;

    public IfxImmutableClob(String value, String encoding) {
        this.value = value;
        this.encoding = encoding == null ? "ISO8859_1" : encoding;
    }

    @Override
    public long length() throws SQLException {
        return this.value.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L || length < 0) {
            throw IfxErrMsg.getSQLException(-80502);
        }
        if (length == 0) {
            return "";
        }
        return this.value.substring((int)pos - 1, (int)(pos + (long)length - 1L));
    }

    @Override
    public Reader getCharacterStream() {
        return new StringReader(this.value);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(this.value.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw IfxErrMsg.getSQLException(-79783, "", this.encoding);
        }
    }

    @Override
    public long position(String searchstr, long start) {
        return this.value.indexOf(searchstr, (int)start);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        if (searchstr.length() > Integer.MAX_VALUE) {
            throw new SQLException("clob length is too great to search");
        }
        byte[] bytes = new byte[(int)searchstr.length()];
        try {
            return this.value.indexOf(new String(bytes, this.encoding), (int)start);
        }
        catch (UnsupportedEncodingException e) {
            throw IfxErrMsg.getSQLException(-79783, "", this.encoding);
        }
    }

    @Override
    public int setString(long pos, String str) {
        throw new UnsupportedOperationException("setString");
    }

    @Override
    public int setString(long pos, String str, int offset, int len) {
        throw new UnsupportedOperationException("setString");
    }

    @Override
    public OutputStream setAsciiStream(long pos) {
        throw new UnsupportedOperationException("setAsciiStream");
    }

    @Override
    public Writer setCharacterStream(long pos) {
        throw new UnsupportedOperationException("setCharacterStream");
    }

    @Override
    public void truncate(long len) {
        throw new UnsupportedOperationException("truncate");
    }

    @Override
    public void free() throws SQLException {
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        return new StringReader(this.value.substring((int)pos, (int)length));
    }
}

