/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.crypto.IfxCryptoUtils;

class IfxCHash {
    byte[] Hash;
    long LastHash;
    int Sub;
    int SubDir;
    int SubStart;
    int SubEnd;
    private static final int PRODUCT_CSIZE = 4;

    IfxCHash() {
    }

    void init(int s, int d, int e) {
        this.LastHash = 0L;
        this.Sub = (short)s;
        this.SubDir = (short)d;
        this.SubStart = (short)s;
        this.SubEnd = (short)e;
    }

    void reset() {
        this.init(0, 0, 0);
        this.Hash = null;
    }

    static int generateHash(IfxCHash hash, int length, byte[] key) {
        boolean status = false;
        long product = 0L;
        long lastHash = hash.LastHash;
        int sub = hash.Sub;
        hash.Hash = new byte[length];
        int charEnd = hash.Hash.length;
        int charPos = 0;
        while (charPos < charEnd) {
            if (sub == hash.SubEnd) {
                sub = hash.SubStart;
            }
            if (lastHash == 0L) {
                lastHash = IfxCryptoUtils.Ifx2ToJavaInt(key, sub);
                sub += hash.SubDir;
                continue;
            }
            if ((lastHash & 0xFFFFL) == 0L) {
                lastHash = IfxCryptoUtils.Ifx2ToJavaInt(key, sub);
                sub += hash.SubDir;
                continue;
            }
            product = (lastHash & 0xFFFFL) * (long)IfxCryptoUtils.Ifx2ToJavaInt(key, sub);
            sub += hash.SubDir;
            if (charEnd - charPos < 4) {
                long tProduct = product;
                while (charPos < charEnd) {
                    System.arraycopy(new byte[]{(byte)(tProduct & 0xFFL)}, 0, hash.Hash, charPos, 1);
                    ++charPos;
                    tProduct >>= 8;
                }
            } else {
                System.arraycopy(IfxCryptoUtils.JavaToIfxLong(product, 4), 0, hash.Hash, charPos, 4);
                charPos += 4;
            }
            lastHash = product << 1 | (long)((product & Integer.MIN_VALUE) > 0L ? 0 : 1);
        }
        hash.Sub = sub;
        hash.LastHash = lastHash;
        return 0;
    }
}

