/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm;

import com.informix.csm.IfxCSSException;
import com.informix.csm.IfxCsm;
import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmDescriptor;
import com.informix.csm.IfxCsmException;
import com.informix.csm.IfxCsmReadBuffer;
import com.informix.csm.IfxCssInputStream;
import com.informix.csm.IfxCssOutputStream;
import com.informix.util.IfxErrMsg;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class IfxCsmContext {
    public static int CSM_SERVER = 262144;
    static int CSS_REQUEST_PENDING = 0;
    static int CSS_REQUEST_POSTED = 1;
    static int CSS_CSM_HAS_DATA = 0;
    static int CSS_CSM_NO_DATA = 1;
    static int CSS_CSM_FREE = 0;
    static int CSS_CSM_IN_USE = 1;
    static int CSS_CSM_DONE = 0;
    static int CSS_CSM_CALL = 1;
    IfxCsm.Status status;
    IfxCsm csm;
    IfxCsm.Credentials cred;
    IfxCsmDescriptor desc;
    String locale;
    int state_out = CSS_CSM_NO_DATA;
    int state_in = CSS_CSM_FREE;
    int state_obj = CSS_CSM_DONE;
    IfxCsmReadBuffer inHandShake;
    IfxCsmBuffer outHandShake;

    int createContext(IfxCsm.Credentials creds) throws IfxCSSException {
        int svc_state = CSS_REQUEST_PENDING;
        int ret = 0;
        IfxCsm.Status status = new IfxCsm.Status();
        while ((ret = this.csm.ifxCsmCreateContext(creds, this.inHandShake, this.outHandShake, this.desc.getInitString(), status)) == 0) {
            this.setState(status);
            if (this.state_out != CSS_CSM_HAS_DATA) {
                if (this.state_obj == CSS_CSM_DONE) break;
                if (svc_state == CSS_REQUEST_PENDING) {
                    throw IfxErrMsg.getLocIfxCSSException(-14513, this.locale);
                }
            }
            if (this.state_out == CSS_CSM_HAS_DATA) {
                this.putBytes(this.outHandShake.toByteArray());
                this.outHandShake.reset();
                svc_state = CSS_REQUEST_POSTED;
            }
            if (this.state_in == CSS_CSM_IN_USE) continue;
            this.inHandShake = null;
            this.inHandShake = this.getBytes();
        }
        return ret;
    }

    private void putBytes(byte[] msg) throws IfxCSSException {
        try {
            this.desc.getOutputStream().write(msg);
            this.desc.getOutputStream().flush();
        }
        catch (IOException ex) {
            throw IfxErrMsg.getLocIfxCSSException(-14563, this.locale);
        }
    }

    private IfxCsmReadBuffer getBytes() throws IfxCSSException {
        IfxCsmBuffer buff = new IfxCsmBuffer();
        byte[] buffer = new byte[4096];
        int readBytes = -1;
        try {
            readBytes = this.desc.getInputStream().read(buffer);
            if (readBytes != -1) {
                buff.write(buffer, 0, readBytes);
            }
        }
        catch (IOException ex) {
            throw IfxErrMsg.getLocIfxCSSException(-14565, this.locale);
        }
        return new IfxCsmReadBuffer(buff);
    }

    private void setState(IfxCsm.Status status) {
        long csm_code = status.getCsmCode();
        if (csm_code == 1L) {
            this.state_out = CSS_CSM_NO_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_DONE;
        } else if (csm_code == 2L) {
            this.state_out = CSS_CSM_NO_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_DONE;
        } else if (csm_code == 3L) {
            this.state_out = CSS_CSM_HAS_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_CALL;
        } else if (csm_code == 4L) {
            this.state_out = CSS_CSM_HAS_DATA;
            this.state_in = CSS_CSM_IN_USE;
            this.state_obj = CSS_CSM_CALL;
        } else if (csm_code == 5L) {
            this.state_out = CSS_CSM_NO_DATA;
            this.state_in = CSS_CSM_FREE;
            this.state_obj = CSS_CSM_CALL;
        }
    }

    public IfxCsmContext(IfxCsmDescriptor desc, String locale) throws IfxCSSException {
        this.desc = desc;
        this.locale = locale;
        this.status = new IfxCsm.Status();
        this.outHandShake = new IfxCsmBuffer();
        this.csm = this.createCsmObject();
    }

    private IfxCsm createCsmObject() throws IfxCSSException {
        IfxCsm newCsm = null;
        Class<?> csmClass = null;
        this.desc.setLoadState(0);
        try {
            Class<?> ifxCsmInterface = Class.forName("com.informix.csm.IfxCsm");
            csmClass = Class.forName(this.desc.getClassName());
            if (!ifxCsmInterface.isAssignableFrom(csmClass)) {
                this.desc.setLoadState(2);
                throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n", this.locale);
            }
            Class[] classArgs = new Class[]{this.desc.getClass()};
            Constructor<?> cons = csmClass.getConstructor(classArgs);
            Object[] objs = new Object[]{this.desc};
            newCsm = (IfxCsm)cons.newInstance(objs);
        }
        catch (ClassNotFoundException ex1) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + ex1.toString(), this.locale);
        }
        catch (IllegalAccessException ex2) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + ex2.toString(), this.locale);
        }
        catch (InstantiationException ex3) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + ex3.toString(), this.locale);
        }
        catch (NoSuchMethodException ex4) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + ex4.toString(), this.locale);
        }
        catch (InvocationTargetException ex5) {
            this.desc.setLoadState(2);
            throw IfxErrMsg.getLocIfxCSSException(-14574, this.desc.getClassName() + "\n" + ex5.toString(), this.locale);
        }
        this.desc.setLoadState(1);
        return newCsm;
    }

    public void init() throws IfxCSSException {
        try {
            this.csm.ifxCsmInit(this.desc.getInitString(), 0L, this.status);
        }
        catch (IfxCsmException ex) {
            this.desc.setLoadState(this.status.csmErr);
            throw ex;
        }
    }

    public IfxCsm.Status getStatus() {
        return this.status;
    }

    public FilterInputStream getInputStream() {
        return new IfxCssInputStream(this.desc.getInputStream(), this.csm);
    }

    public FilterOutputStream getOutputStream() {
        return new IfxCssOutputStream(this.desc.getOutputStream(), this.csm);
    }
}

