/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.servletunit.XMLUtils;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class WebResourceConfiguration {
    private String _className;
    private Hashtable _initParams = new Hashtable();

    WebResourceConfiguration(String className) {
        this._className = className;
    }

    WebResourceConfiguration(String className, Hashtable initParams) {
        this._className = className;
        if (initParams != null) {
            this._initParams = initParams;
        }
    }

    WebResourceConfiguration(Element resourceElement, String resourceNodeName) throws SAXException {
        this(XMLUtils.getChildNodeValue(resourceElement, resourceNodeName));
        NodeList initParams = resourceElement.getElementsByTagName("init-param");
        int i = initParams.getLength() - 1;
        while (i >= 0) {
            this._initParams.put(XMLUtils.getChildNodeValue((Element)initParams.item(i), "param-name"), XMLUtils.getChildNodeValue((Element)initParams.item(i), "param-value"));
            --i;
        }
    }

    abstract void destroyResource();

    String getClassName() {
        return this._className;
    }

    Hashtable getInitParams() {
        return this._initParams;
    }

    abstract boolean isLoadOnStartup();
}

