/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.parsing;

import com.meterware.httpunit.parsing.DocumentAdapter;
import com.meterware.httpunit.parsing.ErrorHandler;
import com.meterware.httpunit.parsing.HTMLParserFactory;
import com.meterware.httpunit.parsing.ScriptFilter;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.net.URL;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

class NekoDOMParser
extends DOMParser {
    private static final String HTML_DOCUMENT_CLASS_NAME = "org.apache.html.dom.HTMLDocumentImpl";
    private static final String REPORT_ERRORS = "http://cyberneko.org/html/features/report-errors";
    private static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    private static final String FILTERS = "http://cyberneko.org/html/properties/filters";
    private static final String TAG_NAME_CASE = "http://cyberneko.org/html/properties/names/elems";
    private static final String ATTRIBUTE_NAME_CASE = "http://cyberneko.org/html/properties/names/attrs";
    private DocumentAdapter _documentAdapter;
    private Node _documentNode;

    static NekoDOMParser newParser(DocumentAdapter adapter, URL url) {
        HTMLConfiguration configuration = new HTMLConfiguration();
        if (!HTMLParserFactory.getHTMLParserListeners().isEmpty() || HTMLParserFactory.isParserWarningsEnabled()) {
            configuration.setErrorHandler((XMLErrorHandler)new ErrorHandler(url));
            configuration.setFeature(REPORT_ERRORS, true);
        }
        configuration.setFeature(AUGMENTATIONS, true);
        ScriptFilter javaScriptFilter = new ScriptFilter(configuration);
        configuration.setProperty(FILTERS, (Object)new XMLDocumentFilter[]{javaScriptFilter});
        if (HTMLParserFactory.isPreserveTagCase()) {
            configuration.setProperty(TAG_NAME_CASE, (Object)"match");
            configuration.setProperty(ATTRIBUTE_NAME_CASE, (Object)"no-change");
        }
        try {
            NekoDOMParser domParser = new NekoDOMParser(configuration, adapter);
            domParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            if (HTMLParserFactory.isReturnHTMLDocument()) {
                domParser.setProperty("http://apache.org/xml/properties/dom/document-class-name", HTML_DOCUMENT_CLASS_NAME);
            }
            javaScriptFilter.setParser(domParser);
            return domParser;
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException(e.toString());
        }
        catch (SAXNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    ScriptableDelegate getScriptableDelegate() {
        if (this._documentNode == null) {
            Node node = this.getCurrentElementNode();
            while (!(node instanceof Document)) {
                node = node.getParentNode();
            }
            this._documentNode = node;
        }
        this._documentAdapter.setRootNode(this._documentNode);
        return this._documentAdapter.getScriptableObject();
    }

    private Node getCurrentElementNode() {
        try {
            Node node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
            return node;
        }
        catch (SAXNotRecognizedException e) {
            throw new RuntimeException("http://apache.org/xml/properties/dom/current-element-node property not recognized");
        }
        catch (SAXNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException("http://apache.org/xml/properties/dom/current-element-node property not supported");
        }
    }

    String getIncludedScript(String srcAttribute) {
        try {
            return this._documentAdapter.getIncludedScript(srcAttribute);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    NekoDOMParser(HTMLConfiguration configuration, DocumentAdapter adapter) {
        super((XMLParserConfiguration)configuration);
        this._documentAdapter = adapter;
    }

    static class ScriptException
    extends RuntimeException {
        private IOException _cause;

        public ScriptException(IOException cause) {
            this._cause = cause;
        }

        public IOException getException() {
            return this._cause;
        }
    }
}

