/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.AuthorizationRequiredException;
import com.meterware.httpunit.Base64;
import com.meterware.httpunit.ClientProperties;
import com.meterware.httpunit.DialogAdapter;
import com.meterware.httpunit.DialogResponder;
import com.meterware.httpunit.FrameSelector;
import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.HttpInternalErrorException;
import com.meterware.httpunit.HttpNotFoundException;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.RequestContext;
import com.meterware.httpunit.WebClientListener;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebWindow;
import com.meterware.httpunit.WebWindowListener;
import com.meterware.httpunit.cookies.CookieJar;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.SAXException;

public abstract class WebClient {
    private ArrayList _openWindows = new ArrayList();
    private WebWindow _mainWindow = new WebWindow(this);
    private String _authorizationString;
    private String _proxyAuthorizationString;
    private LinkedList _alerts = new LinkedList();
    private CookieJar _cookieJar = new CookieJar();
    private HeaderDictionary _headers = new HeaderDictionary();
    private boolean _exceptionsThrownOnErrorStatus = HttpUnitOptions.getExceptionsThrownOnErrorStatus();
    private List _clientListeners = new ArrayList();
    private List _windowListeners = new ArrayList();
    private DialogResponder _dialogResponder = new DialogAdapter();
    private ClientProperties _clientProperties = ClientProperties.getDefaultProperties().cloneProperties();

    public WebWindow getMainWindow() {
        return this._mainWindow;
    }

    public void setMainWindow(WebWindow mainWindow) {
        if (!this._openWindows.contains(mainWindow)) {
            throw new IllegalArgumentException("May only select an open window owned by this client");
        }
        this._mainWindow = mainWindow;
    }

    public WebWindow[] getOpenWindows() {
        return this._openWindows.toArray(new WebWindow[this._openWindows.size()]);
    }

    public WebWindow getOpenWindow(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        Iterator i = this._openWindows.iterator();
        while (i.hasNext()) {
            WebWindow window = (WebWindow)i.next();
            if (!name.equals(window.getName())) continue;
            return window;
        }
        return null;
    }

    public WebResponse getResponse(String urlString) throws MalformedURLException, IOException, SAXException {
        return this._mainWindow.getResponse(urlString);
    }

    public WebResponse sendRequest(WebRequest request) throws MalformedURLException, IOException, SAXException {
        return this._mainWindow.sendRequest(request);
    }

    public WebResponse getCurrentPage() {
        return this._mainWindow.getCurrentPage();
    }

    public WebResponse getResponse(WebRequest request) throws MalformedURLException, IOException, SAXException {
        return this._mainWindow.getResponse(request);
    }

    public String[] getFrameNames() {
        return this._mainWindow.getFrameNames();
    }

    public WebResponse getFrameContents(String frameName) {
        return this._mainWindow.getFrameContents(frameName);
    }

    public WebResponse getFrameContents(FrameSelector targetFrame) {
        return this._mainWindow.getFrameContents(targetFrame);
    }

    public WebResponse getResource(WebRequest request) throws IOException {
        return this._mainWindow.getResource(request);
    }

    public void clearContents() {
        this._mainWindow = new WebWindow(this);
        this._cookieJar.clear();
        this._headers = new HeaderDictionary();
    }

    public void addCookie(String name, String value) {
        this._cookieJar.addCookie(name, value);
    }

    public void putCookie(String name, String value) {
        this._cookieJar.putCookie(name, value);
    }

    public String[] getCookieNames() {
        return this._cookieJar.getCookieNames();
    }

    public String getCookieValue(String name) {
        return this._cookieJar.getCookieValue(name);
    }

    public ClientProperties getClientProperties() {
        return this._clientProperties;
    }

    public void setUserAgent(String userAgent) {
        this.getClientProperties().setUserAgent(userAgent);
    }

    public String getUserAgent() {
        return this.getClientProperties().getUserAgent();
    }

    public void setAuthorization(String userName, String password) {
        this._authorizationString = "Basic " + Base64.encode(userName + ':' + password);
    }

    public void setProxyServer(String proxyHost, int proxyPort) {
    }

    public void setProxyServer(String proxyHost, int proxyPort, String userName, String password) {
        this.setProxyServer(proxyHost, proxyPort);
        this._proxyAuthorizationString = "Basic " + Base64.encode(userName + ':' + password);
    }

    public void clearProxyServer() {
    }

    public String getProxyHost() {
        return System.getProperty("proxyHost");
    }

    public int getProxyPort() {
        try {
            return Integer.parseInt(System.getProperty("proxyPort"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setHeaderField(String fieldName, String fieldValue) {
        this._headers.put(fieldName, fieldValue);
    }

    public String getHeaderField(String fieldName) {
        return (String)this._headers.get(fieldName);
    }

    public void setExceptionsThrownOnErrorStatus(boolean throwExceptions) {
        this._exceptionsThrownOnErrorStatus = throwExceptions;
    }

    public boolean getExceptionsThrownOnErrorStatus() {
        return this._exceptionsThrownOnErrorStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientListener(WebClientListener listener) {
        List list = this._clientListeners;
        synchronized (list) {
            if (listener != null && !this._clientListeners.contains(listener)) {
                this._clientListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientListener(WebClientListener listener) {
        List list = this._clientListeners;
        synchronized (list) {
            this._clientListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowListener(WebWindowListener listener) {
        List list = this._windowListeners;
        synchronized (list) {
            if (listener != null && !this._windowListeners.contains(listener)) {
                this._windowListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowListener(WebWindowListener listener) {
        List list = this._windowListeners;
        synchronized (list) {
            this._windowListeners.remove(listener);
        }
    }

    public String getNextAlert() {
        return this._alerts.isEmpty() ? null : (String)this._alerts.getFirst();
    }

    public String popNextAlert() {
        if (this._alerts.isEmpty()) {
            return "";
        }
        return (String)this._alerts.removeFirst();
    }

    public void setDialogResponder(DialogResponder responder) {
        this._dialogResponder = responder;
    }

    protected WebClient() {
        this._openWindows.add(this._mainWindow);
    }

    protected abstract WebResponse newResponse(WebRequest var1, FrameSelector var2) throws MalformedURLException, IOException;

    protected final void writeMessageBody(WebRequest request, OutputStream stream) throws IOException {
        request.writeMessageBody(stream);
    }

    protected Dictionary getHeaderFields(URL targetURL) {
        Hashtable result = (Hashtable)this._headers.clone();
        result.put("User-Agent", this.getClientProperties().getUserAgent());
        if (this.getClientProperties().isAcceptGzip()) {
            result.put("Accept-Encoding", "gzip");
        }
        this.AddHeaderIfNotNull(result, "Cookie", this._cookieJar.getCookieHeaderField(targetURL));
        this.AddHeaderIfNotNull(result, "Authorization", this._authorizationString);
        this.AddHeaderIfNotNull(result, "Proxy-Authorization", this._proxyAuthorizationString);
        return result;
    }

    private void AddHeaderIfNotNull(Hashtable result, String headerName, String headerValue) {
        if (headerValue != null) {
            result.put(headerName, headerValue);
        }
    }

    protected final void updateMainWindow(FrameSelector frame, WebResponse response) throws MalformedURLException, IOException, SAXException {
        this.getMainWindow().updateWindow(frame.getName(), response, new RequestContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tellListeners(WebRequest request) {
        ArrayList listeners;
        List list = this._clientListeners;
        synchronized (list) {
            listeners = new ArrayList(this._clientListeners);
        }
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            ((WebClientListener)i.next()).requestSent(this, request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tellListeners(WebResponse response) {
        ArrayList listeners;
        List list = this._clientListeners;
        synchronized (list) {
            listeners = new ArrayList(this._clientListeners);
        }
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            ((WebClientListener)i.next()).responseReceived(this, response);
        }
    }

    void updateClient(WebResponse response) throws IOException {
        if (this.getClientProperties().isAcceptCookies()) {
            this._cookieJar.updateCookies(response.getCookieJar());
        }
        this.validateHeaders(response);
    }

    CookieJar getCookieJar() {
        return this._cookieJar;
    }

    void updateFrameContents(WebWindow requestWindow, String requestTarget, WebResponse response, RequestContext requestContext) throws IOException, SAXException {
        if (response.getFrame() == FrameSelector.NEW_FRAME) {
            WebWindow window = new WebWindow(this, requestWindow.getCurrentPage());
            if (!"_blank".equalsIgnoreCase(requestTarget)) {
                window.setName(requestTarget);
            }
            response.setFrame(window.getTopFrame());
            window.updateFrameContents(response, requestContext);
            this._openWindows.add(window);
            this.reportWindowOpened(window);
        } else if (response.getFrame().getWindow() != null && response.getFrame().getWindow() != requestWindow) {
            response.getFrame().getWindow().updateFrameContents(response, requestContext);
        } else {
            if (response.getFrame() == FrameSelector.TOP_FRAME) {
                response.setFrame(requestWindow.getTopFrame());
            }
            requestWindow.updateFrameContents(response, requestContext);
        }
    }

    void close(WebWindow window) {
        if (!this._openWindows.contains(window)) {
            throw new IllegalStateException("Window is already closed");
        }
        this._openWindows.remove(window);
        if (this._openWindows.isEmpty()) {
            this._openWindows.add(new WebWindow(this));
        }
        if (window.equals(this._mainWindow)) {
            this._mainWindow = (WebWindow)this._openWindows.get(0);
        }
        this.reportWindowClosed(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportWindowOpened(WebWindow window) {
        ArrayList listeners;
        List list = this._windowListeners;
        synchronized (list) {
            listeners = new ArrayList(this._windowListeners);
        }
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            ((WebWindowListener)i.next()).windowOpened(this, window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportWindowClosed(WebWindow window) {
        ArrayList listeners;
        List list = this._windowListeners;
        synchronized (list) {
            listeners = new ArrayList(this._windowListeners);
        }
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            ((WebWindowListener)i.next()).windowClosed(this, window);
        }
    }

    boolean getConfirmationResponse(String message) {
        return this._dialogResponder.getConfirmation(message);
    }

    String getUserResponse(String message, String defaultResponse) {
        return this._dialogResponder.getUserResponse(message, defaultResponse);
    }

    void postAlert(String message) {
        this._alerts.addLast(message);
    }

    private void validateHeaders(WebResponse response) throws HttpException {
        if (!this.getExceptionsThrownOnErrorStatus()) {
            return;
        }
        if (response.getHeaderField("WWW-Authenticate") != null) {
            throw new AuthorizationRequiredException(response.getHeaderField("WWW-Authenticate"));
        }
        if (response.getResponseCode() == 500) {
            throw new HttpInternalErrorException(response.getURL());
        }
        if (response.getResponseCode() == 404) {
            throw new HttpNotFoundException(response.getResponseMessage(), response.getURL());
        }
        if (response.getResponseCode() >= 400) {
            throw new HttpException(response.getResponseCode(), response.getResponseMessage(), response.getURL());
        }
    }

    FrameSelector findFrame(String target) {
        int i = 0;
        while (i < this._openWindows.size()) {
            WebWindow webWindow = (WebWindow)this._openWindows.get(i);
            FrameSelector frame = webWindow.getFrame(target);
            if (frame != null) {
                return frame;
            }
            ++i;
        }
        return null;
    }

    public static class HeaderDictionary
    extends Hashtable {
        public void addEntries(Dictionary source) {
            Enumeration e = source.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                this.put(key, source.get(key));
            }
        }

        public boolean containsKey(Object key) {
            return super.containsKey(this.matchPreviousFieldName(key.toString()));
        }

        public Object get(Object fieldName) {
            return (String)super.get(this.matchPreviousFieldName(fieldName.toString()));
        }

        public Object put(Object fieldName, Object fieldValue) {
            fieldName = this.matchPreviousFieldName(fieldName.toString());
            Object oldValue = super.get(fieldName);
            if (fieldValue == null) {
                this.remove(fieldName);
            } else {
                super.put(fieldName, fieldValue);
            }
            return oldValue;
        }

        private String matchPreviousFieldName(String fieldName) {
            Enumeration e = this.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.equalsIgnoreCase(fieldName)) continue;
                return key;
            }
            return fieldName;
        }
    }
}

