/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

class TransferResultSet {
    Vector vRows = new Vector();
    int iRowIdx = 0;
    int iMaxRowIdx = 0;
    int iColumnCount = 0;
    String[] sColumnNames = null;
    int[] iColumnTypes = null;

    TransferResultSet(ResultSet resultSet) {
        try {
            while (resultSet.next()) {
                if (this.sColumnNames == null) {
                    this.iColumnCount = resultSet.getMetaData().getColumnCount();
                    this.sColumnNames = new String[this.iColumnCount + 1];
                    this.iColumnTypes = new int[this.iColumnCount + 1];
                    for (int i = 0; i < this.iColumnCount; ++i) {
                        this.sColumnNames[i + 1] = resultSet.getMetaData().getColumnName(i + 1);
                        this.iColumnTypes[i + 1] = resultSet.getMetaData().getColumnType(i + 1);
                    }
                    this.vRows.addElement(null);
                }
                ++this.iMaxRowIdx;
                Object[] objectArray = new Object[this.iColumnCount + 1];
                for (int i = 0; i < this.iColumnCount; ++i) {
                    objectArray[i + 1] = resultSet.getObject(i + 1);
                }
                this.vRows.addElement(objectArray);
            }
        }
        catch (SQLException sQLException) {
            this.iRowIdx = 0;
            this.iMaxRowIdx = 0;
            this.iColumnCount = 0;
            this.vRows = new Vector();
        }
    }

    TransferResultSet() {
    }

    void addRow(String[] stringArray, int[] nArray, Object[] objectArray, int n) throws Exception {
        if (stringArray.length != nArray.length || stringArray.length != objectArray.length || stringArray.length != n + 1) {
            throw new Exception("Size of parameter incoherent");
        }
        if (this.sColumnNames == null) {
            this.iColumnCount = n;
            this.sColumnNames = stringArray;
            this.iColumnTypes = nArray;
            this.vRows.addElement(null);
        }
        if (this.iMaxRowIdx > 0 && this.getColumnCount() != n) {
            throw new Exception("Wrong number of columns: " + this.getColumnCount() + " column is expected");
        }
        ++this.iMaxRowIdx;
        this.vRows.addElement(objectArray);
    }

    boolean next() {
        ++this.iRowIdx;
        return this.iRowIdx <= this.iMaxRowIdx && this.iMaxRowIdx > 0;
    }

    String getColumnName(int n) {
        if (this.iMaxRowIdx <= 0 || this.iMaxRowIdx < this.iRowIdx) {
            return null;
        }
        return this.sColumnNames[n];
    }

    int getColumnCount() {
        if (this.iMaxRowIdx <= 0 || this.iMaxRowIdx < this.iRowIdx) {
            return 0;
        }
        return this.iColumnCount;
    }

    int getColumnType(int n) {
        if (this.iMaxRowIdx <= 0 || this.iMaxRowIdx < this.iRowIdx) {
            return 0;
        }
        return this.iColumnTypes[n];
    }

    Object getObject(int n) {
        if (this.iMaxRowIdx <= 0 || this.iMaxRowIdx < this.iRowIdx) {
            return null;
        }
        return ((Object[])this.vRows.elementAt(this.iRowIdx))[n];
    }
}

