/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.User;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.store.ValuePool;

class UserManager {
    static final int SELECT = 1;
    static final int DELETE = 2;
    static final int INSERT = 4;
    static final int UPDATE = 8;
    static final int ALL = 15;
    static final Integer INTEGER_ALL = ValuePool.getInt(15);
    static final String S_R_ALL = "ALL";
    static final String S_R_SELECT = "SELECT";
    static final String S_R_UPDATE = "UPDATE";
    static final String S_R_DELETE = "DELETE";
    static final String S_R_INSERT = "INSERT";
    static final IntValueHashMap rightsStringLookup = new IntValueHashMap(7);
    private HashMappedList uUser = new HashMappedList();
    private User uPublic = this.createUser("PUBLIC", null, false);
    static final String SYS_USER_NAME = "SYS";
    static final String PUBLIC_USER_NAME = "PUBLIC";
    static final String[] emptyRightsList;
    static final IntKeyHashMap hRightsLists;

    UserManager() throws HsqlException {
    }

    static int getRight(String string) {
        return rightsStringLookup.get((Object)string, 0);
    }

    static String getRight(int n) {
        if (n == 0) {
            return null;
        }
        if (n == 15) {
            return S_R_ALL;
        }
        return StringUtil.getList(UserManager.getRightsArray(n), ",", "");
    }

    static String[] getRightsArray(int n) {
        if (n == 0) {
            return emptyRightsList;
        }
        String[] stringArray = (String[])hRightsLists.get(n);
        if (stringArray != null) {
            return stringArray;
        }
        stringArray = UserManager.getRightsArraySub(n);
        hRightsLists.put(n, stringArray);
        return stringArray;
    }

    private static String[] getRightsArraySub(int n) {
        if (n == 0) {
            return emptyRightsList;
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator = rightsStringLookup.keySet().iterator();
        while (iterator.hasNext()) {
            int n2;
            String string = (String)iterator.next();
            if (string.equals(S_R_ALL) || (n & (n2 = rightsStringLookup.get((Object)string, 0))) == 0) continue;
            hsqlArrayList.add(string);
        }
        return (String[])hsqlArrayList.toArray(new String[hsqlArrayList.size()]);
    }

    User createUser(String string, String string2, boolean bl) throws HsqlException {
        Trace.doAssert(string != null, "name is null");
        if (SYS_USER_NAME.equals(string)) {
            throw Trace.error(36, string);
        }
        User user = new User(string, string2, bl, this.uPublic);
        if (!this.uUser.add(string, user)) {
            throw Trace.error(36, string);
        }
        return user;
    }

    void dropUser(String string) throws HsqlException {
        Trace.check(!string.equals(PUBLIC_USER_NAME), 33);
        User user = (User)this.uUser.remove(string);
        if (user == null) {
            throw Trace.error(37, string);
        }
        user.revokeAll();
    }

    User getUser(String string, String string2) throws HsqlException {
        Trace.check(!string.equals(PUBLIC_USER_NAME), 33);
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        User user = this.get(string);
        Trace.check(user != null, 37, string);
        user.checkPassword(string2);
        return user;
    }

    HashMappedList getUsers() {
        return this.uUser;
    }

    void grant(String string, Object object, int n) throws HsqlException {
        this.get(string).grant(object, n);
    }

    void revoke(String string, Object object, int n) throws HsqlException {
        this.get(string).revoke(object, n);
    }

    boolean exists(String string) {
        int n = this.uUser.size();
        while (n-- > 0) {
            User user = (User)this.uUser.get(n);
            if (user == null || !user.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    User get(String string) throws HsqlException {
        User user = (User)this.uUser.get(string);
        if (user == null) {
            throw Trace.error(37, string);
        }
        return user;
    }

    void removeDbObject(Object object) {
        Iterator iterator = this.uUser.values().iterator();
        while (iterator.hasNext()) {
            User user = (User)iterator.next();
            user.revokeDbObject(object);
        }
    }

    HsqlArrayList listVisibleUsers(Session session, boolean bl) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        boolean bl2 = session.isAdmin();
        String string = session.getUsername();
        if (this.uUser == null || this.uUser.size() == 0) {
            return hsqlArrayList;
        }
        for (int i = 0; i < this.uUser.size(); ++i) {
            User user = (User)this.uUser.get(i);
            if (user == null) continue;
            String string2 = user.getName();
            if (PUBLIC_USER_NAME.equals(string2)) {
                if (!bl) continue;
                hsqlArrayList.add(user);
                continue;
            }
            if (bl2) {
                hsqlArrayList.add(user);
                continue;
            }
            if (!string.equals(string2)) continue;
            hsqlArrayList.add(user);
        }
        return hsqlArrayList;
    }

    HashSet getGrantedClassNames() {
        int n = this.uUser.size();
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            User user = (User)this.uUser.get(i);
            if (user == null) continue;
            Iterator iterator = user.getGrantedClassNames(false).iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        return hashSet;
    }

    static User createSysUser(Database database) throws HsqlException {
        return new User(SYS_USER_NAME, null, true, null);
    }

    static {
        rightsStringLookup.put(S_R_ALL, 15);
        rightsStringLookup.put(S_R_SELECT, 1);
        rightsStringLookup.put(S_R_UPDATE, 8);
        rightsStringLookup.put(S_R_DELETE, 2);
        rightsStringLookup.put(S_R_INSERT, 4);
        emptyRightsList = new String[0];
        hRightsLists = new IntKeyHashMap();
    }
}

