/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.net.SimpleIMAPClient;
import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.StringUtil;
import java.io.IOException;
import java.util.Properties;
import javax.mail.URLName;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class SimpleImapAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(SimpleImapAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        try {
            String charset = confElement.getChildTextTrim("charset");
            if (charset == null) {
                charset = System.getProperty("file.encoding", "UTF-8");
            }
            URLName url = new URLName(StringUtil.argsubst(confElement.getChildTextTrim("url"), authProp));
            SimpleIMAPClient client = new SimpleIMAPClient(url, charset);
            client.checkGreeting();
            if (client.login()) {
                userProp.put("authenticated", "y");
            }
            client.close();
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return userProp;
    }
}

