/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.PropUtil;
import de.his.tools.ReflectionUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class ContainerAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(ContainerAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        if (request == null) {
            logger.debug((Object)"request==null");
            return userProp;
        }
        String remoteUser = request.getRemoteUser();
        if (remoteUser == null) {
            remoteUser = (String)request.getAttribute("de.his.appserver.model.cs.sys.authentication.remoteUser");
        }
        if (remoteUser != null && remoteUser.trim().length() > 0) {
            userProp.put("authenticated", "y");
            userProp.put("username", remoteUser.trim());
            PropUtil.putIgnoreNull(userProp, "authtype", request.getAuthType());
            this.processRoleMapping(confElement, userProp, request);
            userProp.putAll((Map<?, ?>)PropUtil.xmlToProperties(confElement.getChild("user-prop")));
        }
        return userProp;
    }

    public void processRoleMapping(Element confElement, Properties userProp, HttpServletRequest request) {
        if (request == null && !ReflectionUtil.isCalledByJUnit()) {
            logger.debug((Object)"request==null");
            return;
        }
        Properties roles = PropUtil.xmlToProperties(confElement.getChild("RoleMapping"));
        StringBuffer res = new StringBuffer();
        Iterator<Object> itr = roles.keySet().iterator();
        while (itr.hasNext()) {
            String role;
            String containerRole = role = (String)itr.next();
            if (role.startsWith("_")) {
                containerRole = role.substring(1);
            }
            if (request != null && !request.isUserInRole(containerRole)) continue;
            if (res.length() > 0) {
                res.append(",");
            }
            res.append(roles.getProperty(role));
        }
        String rolesStr = res.toString();
        if (rolesStr.length() > 0) {
            userProp.put("roles", rolesStr);
            String bereich = null;
            int pos = rolesStr.indexOf(",");
            bereich = pos > -1 ? rolesStr.substring(0, pos) : rolesStr;
            PropUtil.putIgnoreNull(userProp, "bereich", bereich);
        }
    }
}

