/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth;

import de.his.security.auth.AuthenticationDispatcher;
import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.ConfigurationPreprocessor;
import de.his.security.auth.PluginFactory;
import de.his.security.auth.passwordevent.PasswordEvent;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.security.auth.plugin.PasswordChanger;
import de.his.tools.PropUtil;
import de.his.tools.ReflectionUtil;
import de.his.tools.StringUtil;
import de.his.tools.XMLUtil;
import de.his.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public final class AuthenticationManager {
    private final Logger logger = Logger.getLogger(AuthenticationManager.class);
    private static final String CONFIGURATION_PREPROCESSOR = "configuration-preprocessor";
    private static final String CONFIGURATION_PREPROCESSOR_INTERFACE = ConfigurationPreprocessor.class.getName();
    private static final String LOGIN_CONF_NAME = "LoginConf.xml";
    public static final String ROLES = "roles";
    private static final String TYPE = "type";
    private static AuthenticationManager manager = null;
    private boolean inited = false;
    private AuthenticationManagerConfig config;
    private Element confElement;

    private AuthenticationManager() {
    }

    public static synchronized AuthenticationManager getManager() {
        if (manager == null) {
            manager = new AuthenticationManager();
        }
        return manager;
    }

    public void init(AuthenticationManagerConfig config) {
        if (!this.inited) {
            if (config == null) {
                throw new IllegalArgumentException("config darf kein null-Wert sein");
            }
            this.config = config;
            this.refreshConfElement();
            this.inited = true;
        } else {
            this.logger.warn((Object)"Die Initialisierung darf man nur ein mal aufrufen. Es wurde keine Initialisierung durchgef\u00fchrt.");
        }
    }

    private void refreshConfElement() {
        ConfigurationPreprocessor confPreprocessor;
        String loginconf = this.config.getConfigFileName();
        loginconf = loginconf == null || loginconf.length() == 0 ? this.config.getConfigRoot() + LOGIN_CONF_NAME : this.config.getConfigRoot() + loginconf;
        this.confElement = XMLUtil.getElementFromFile(loginconf);
        String confPreConf = this.confElement.getChildText(CONFIGURATION_PREPROCESSOR);
        if (confPreConf != null && (confPreprocessor = (ConfigurationPreprocessor)ReflectionUtil.createObject(confPreConf, CONFIGURATION_PREPROCESSOR_INTERFACE)) != null) {
            confPreprocessor.init(this.config, loginconf);
            this.confElement = confPreprocessor.preprocessConfiguration();
        }
        PluginFactory.initPlugins(this.config, this.confElement);
    }

    public ArrayList<String> changePassword(Object authPath, Properties authProps, HttpServletRequest request) {
        ArrayList<String> res = new ArrayList<String>();
        if (authPath == null) {
            this.logger.error((Object)"authPath is null");
            res.add("password_fatal");
            return res;
        }
        if (!(authPath instanceof List)) {
            this.logger.error((Object)"authPath is not a list");
            res.add("password_fatal");
            return res;
        }
        if (((List)authPath).size() < 1) {
            this.logger.error((Object)"authPath is leer");
            res.add("password_fatal");
            return res;
        }
        for (Object entry : (List)authPath) {
            if (!(entry instanceof Pair)) continue;
            Element element = (Element)((Pair)entry).getKey();
            if (element == null) {
                this.logger.error((Object)"element null");
                res.add("password_fatal");
                continue;
            }
            PasswordChanger changer = this.getPasswordChanger(element);
            if (changer == null) continue;
            Properties authPropsLocal = (Properties)authProps.clone();
            Properties userProp = new Properties();
            if ((userProp = changer.authTest(element, authPropsLocal, request, userProp)) == null) {
                res.add("password_wrong");
                continue;
            }
            if (userProp.getProperty("userID") == null) {
                res.add("password_wrong");
                continue;
            }
            if (!changer.isPasswortChangeable(element)) {
                res.add("password_fatal");
            } else {
                String pwtidc = (String)((Pair)entry).getValue();
                if (pwtidc != null) {
                    authPropsLocal.put("pwtidc", pwtidc);
                }
                res = changer.changePasswort(element, authPropsLocal);
            }
            if (!res.isEmpty()) continue;
            Element changePassword = element.getChild("change-password");
            for (Element notify : XMLUtil.getChildren(changePassword, "notify")) {
                PasswordEvent event = (PasswordEvent)ReflectionUtil.createObject(notify.getAttributeValue("class"), PasswordEvent.class.getName());
                authPropsLocal.putAll((Map<?, ?>)userProp);
                event.notify(element, notify, authPropsLocal, res);
            }
        }
        return res;
    }

    public PasswordChanger getPasswordChanger(Element element) {
        String type = element.getAttributeValue(TYPE);
        PasswordChanger passwordChanger = null;
        AuthenticationPlugin authPlugin = PluginFactory.create(type);
        if (authPlugin != null) {
            if (authPlugin instanceof PasswordChanger) {
                passwordChanger = (PasswordChanger)authPlugin;
            }
        } else {
            this.logger.warn((Object)("AuthenticationManager: Unbekanntes Auth-Plugin " + type + " wird bei der Passwort\u00e4nderung ignoriert!"));
        }
        return passwordChanger;
    }

    public Properties getLoginData(Properties authProp) {
        return this.getLoginData(authProp, null);
    }

    public Properties getLoginData(Properties authProp, HttpServletRequest request) {
        Properties resProp = this.verify(authProp, request);
        return PropUtil.filterProperties(resProp, "url:*", true);
    }

    private Properties verify(Properties authProp, HttpServletRequest request) {
        if (this.config.isDevelop()) {
            this.refreshConfElement();
        }
        if (this.confElement == null) {
            this.logger.error((Object)"confElement ist null");
            return new Properties();
        }
        AuthenticationDispatcher dispatcher = new AuthenticationDispatcher(this.confElement);
        Properties userProp = dispatcher.verify(authProp, request);
        userProp = AuthenticationManager.getFirstRole(userProp);
        userProp.put("authPath", dispatcher.getAuthPath());
        if (!userProp.getProperty("userID", "").trim().equals("")) {
            for (Element element : XMLUtil.getChildren(this.confElement.getChild("identity"))) {
                Element check;
                userProp = PropUtil.encodeURL(userProp);
                if (!XMLUtil.isActive(element) || (check = element.getChild("check")) != null && !userProp.getProperty(check.getAttributeValue("key", ""), "").equals(check.getAttributeValue("value", ""))) continue;
                userProp = this.processPlugin(element, authProp, request, userProp);
            }
        }
        if (userProp.getProperty("userID", "").trim().equals("")) {
            userProp.remove("userID");
        }
        return userProp;
    }

    public static Properties getFirstRole(Properties prop) {
        String[] rolesArray;
        String roles = prop.getProperty(ROLES);
        if (roles != null && (rolesArray = StringUtil.stringToArray(roles)).length > 0) {
            prop.put("bereich", rolesArray[0]);
        }
        return prop;
    }

    public Properties processPlugin(Element element, Properties authProp, HttpServletRequest request, Properties userProp) {
        String type = element.getAttributeValue(TYPE);
        if (type == null) {
            this.logger.error((Object)("Im Element " + element.getName() + " fehlt das Attribute type="));
            return userProp;
        }
        AuthenticationPlugin authPlugin = PluginFactory.create(type);
        if (authPlugin == null) {
            this.logger.error((Object)("Unbekanntes Plugin: " + type));
            return userProp;
        }
        try {
            Properties temp = authPlugin.authTest(element, authProp, request, userProp);
            if (temp != null) {
                userProp.putAll((Map<?, ?>)temp);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Fehler im Plugin " + type), (Throwable)e);
        }
        return userProp;
    }

    public AuthenticationManagerConfig getAuthConfig() {
        return this.config;
    }

    public boolean isInited() {
        return this.inited;
    }
}

