/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.datalist.dao;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfigRegistry;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.ResultSetVector;
import org.dbforms.config.Table;
import org.dbforms.util.FileHolder;
import org.dbforms.util.Util;

public abstract class DataSource {
    private static Log logCat = LogFactory.getLog((Class)(class$org$dbforms$event$datalist$dao$DataSource == null ? (class$org$dbforms$event$datalist$dao$DataSource = DataSource.class$("org.dbforms.event.datalist.dao.DataSource")) : class$org$dbforms$event$datalist$dao$DataSource));
    private Table table;
    static /* synthetic */ Class class$org$dbforms$event$datalist$dao$DataSource;

    public abstract void setSelect(FieldValue[] var1, FieldValue[] var2, String var3, FieldValue[] var4);

    public ResultSetVector getCurrent(DbEventInterceptorData interceptorData, String position, int count) throws SQLException {
        try {
            this.open();
            int start = this.findStartRow(position);
            if (count == 0) {
                count = this.size() - start;
            }
            return this.getResultSetVector(interceptorData, start, count);
        }
        catch (Exception e) {
            logCat.error((Object)"getCurrent", (Throwable)e);
            this.close();
            return new ResultSetVector();
        }
    }

    public ResultSetVector getFirst(DbEventInterceptorData interceptorData, int count) throws SQLException {
        try {
            this.open();
            if (count == 0) {
                count = this.size();
            }
            return this.getResultSetVector(interceptorData, 0, count);
        }
        catch (Exception e) {
            logCat.error((Object)"getFirst", (Throwable)e);
            this.close();
            return new ResultSetVector();
        }
    }

    public ResultSetVector getLast(DbEventInterceptorData interceptorData, int count) throws SQLException {
        try {
            this.open();
            return this.getResultSetVector(interceptorData, this.size() - 1, -count);
        }
        catch (Exception e) {
            logCat.error((Object)"getLast", (Throwable)e);
            this.close();
            return new ResultSetVector();
        }
    }

    public ResultSetVector getNext(DbEventInterceptorData interceptorData, String position, int count) throws SQLException {
        try {
            this.open();
            int start = this.findStartRow(position) + 1;
            if (count == 0) {
                count = this.size() - start;
            }
            return this.getResultSetVector(interceptorData, start, count);
        }
        catch (Exception e) {
            logCat.error((Object)"getNext", (Throwable)e);
            this.close();
            return new ResultSetVector();
        }
    }

    public ResultSetVector getPrev(DbEventInterceptorData interceptorData, String position, int count) throws SQLException {
        try {
            this.open();
            int start = this.findStartRow(position) - 1;
            if (count == 0) {
                count = start;
            }
            return this.getResultSetVector(interceptorData, start, -count);
        }
        catch (Exception e) {
            logCat.error((Object)"getPrev", (Throwable)e);
            this.close();
            return new ResultSetVector();
        }
    }

    public void setSelect(String tableList, String whereClause) throws SQLException {
        throw new SQLException("Free form select not implemented");
    }

    public Table getTable() {
        return this.table;
    }

    public void doDelete(DbEventInterceptorData interceptorData, String keyValuesStr) throws SQLException {
    }

    public void doInsert(DbEventInterceptorData interceptorData, FieldValues fieldValues) throws SQLException {
    }

    public void doUpdate(DbEventInterceptorData interceptorData, FieldValues fieldValues, String keyValuesStr) throws SQLException {
    }

    protected void setConnection(Connection con, String dbConnectionName) {
    }

    protected abstract Object[] getRow(int var1) throws SQLException;

    protected abstract void close();

    protected abstract int findStartRow(String var1) throws SQLException;

    protected abstract boolean hasMore(int var1) throws SQLException;

    protected abstract void open() throws SQLException;

    protected abstract int size() throws SQLException;

    protected void setTable(Table table) {
        this.table = table;
    }

    protected void deleteBlobFilesFromDisk(FieldValues fieldValues) throws SQLException {
        Iterator iter = fieldValues.keys();
        while (iter.hasNext()) {
            String fileName;
            String fieldName = (String)iter.next();
            Field curField = this.table.getFieldByName(fieldName);
            if (curField == null) continue;
            int fieldType = curField.getType();
            String directory = null;
            try {
                directory = Util.replaceRealPath(curField.getDirectory(), DbFormsConfigRegistry.instance().lookup().getRealPath());
            }
            catch (Exception e) {
                logCat.error((Object)"deleteBlobFilesFromDisk", (Throwable)e);
                throw new SQLException(e.getMessage());
            }
            if (fieldType != 4200 || Util.isNull(fileName = fieldValues.get(fieldName).getFieldValue().trim())) continue;
            File file = new File(directory, fileName);
            if (file.exists()) {
                file.delete();
                logCat.info((Object)("deleted file " + fileName + " from dir " + directory));
                continue;
            }
            logCat.info((Object)("delete of file " + fileName + " from dir " + directory + " failed because file not found"));
        }
    }

    protected void saveBlobFilesToDisk(FieldValues fieldValues) throws SQLException {
        Iterator iter = fieldValues.keys();
        while (iter.hasNext()) {
            int fieldType;
            String fieldName = (String)iter.next();
            Field curField = this.table.getFieldByName(fieldName);
            if (curField == null || (fieldType = curField.getType()) != 4200) continue;
            String directory = curField.getDirectory();
            if (directory == null) {
                throw new IllegalArgumentException("directory-attribute needed for fields of type DISKBLOB");
            }
            try {
                directory = Util.replaceRealPath(directory, DbFormsConfigRegistry.instance().lookup().getRealPath());
            }
            catch (Exception e) {
                logCat.error((Object)"saveBlobFilesToDisk", (Throwable)e);
            }
            File dir = new File(directory);
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Not a directory: " + directory);
            }
            if (!dir.canWrite()) {
                throw new IllegalArgumentException("Not writable: " + directory);
            }
            FileHolder fileHolder = fieldValues.get(fieldName).getFileHolder();
            if (fileHolder != null) {
                try {
                    fileHolder.writeBufferToFile(dir);
                    logCat.info((Object)"fin + closedy");
                    continue;
                }
                catch (IOException ioe) {
                    logCat.error((Object)"saveBlobFilesToDisk", (Throwable)ioe);
                    throw new SQLException("could not store file '" + fileHolder.getFileName() + "' to dir '" + directory + "'");
                }
            }
            logCat.info((Object)"uh! empty fileHolder");
        }
    }

    protected ResultSetVector getResultSetVector(DbEventInterceptorData interceptorData, int startRow, int count) throws SQLException {
        ResultSetVector result = null;
        result = new ResultSetVector(this.table);
        int begin = 0;
        int ende = 0;
        if (count > 0) {
            Object[] row;
            for (ende = begin = startRow; ende < startRow + count && (row = this.getRow(ende)) != null; ++ende) {
                result.addRow(interceptorData, row);
            }
        } else if (count < 0) {
            Object[] row;
            begin = startRow + count + 1;
            if (begin < 0) {
                begin = 0;
            }
            for (ende = begin; ende <= startRow && (row = this.getRow(ende)) != null; ++ende) {
                result.addRow(interceptorData, row);
            }
        }
        result.setFirstPage(begin <= 0);
        result.setLastPage(!this.hasMore(ende));
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

