/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.classic;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.FieldValue;
import org.dbforms.config.FieldValues;
import org.dbforms.config.ResultSetVector;
import org.dbforms.config.Table;
import org.dbforms.event.NavigationEvent;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.Util;

public class GotoEvent
extends NavigationEvent {
    static Log logCat = LogFactory.getLog((String)(class$org$dbforms$event$classic$GotoEvent == null ? (class$org$dbforms$event$classic$GotoEvent = GotoEvent.class$("org.dbforms.event.classic.GotoEvent")) : class$org$dbforms$event$classic$GotoEvent).getName());
    private String childField;
    private String parentField;
    private String position;
    private String tableList = null;
    private String whereClause = null;
    private Table srcTable;
    static /* synthetic */ Class class$org$dbforms$event$classic$GotoEvent;

    public GotoEvent(String action, HttpServletRequest request, DbFormsConfig config) {
        super(action, request, config);
        String destPos;
        String psrcTable;
        String destTable = ParseUtil.getParameter(request, "data" + action + "_destTable");
        if (destTable == null) {
            this.setTable(null);
            return;
        }
        this.setTable(config.getTableByName(destTable));
        if (this.getTable() == null) {
            this.setTable(config.getTable(Integer.parseInt(destTable)));
        }
        if ((psrcTable = ParseUtil.getParameter(request, "data" + action + "_srcTable")) != null) {
            this.srcTable = config.getTableByName(psrcTable);
            if (this.srcTable == null) {
                this.srcTable = config.getTable(Integer.parseInt(psrcTable));
            }
            this.childField = ParseUtil.getParameter(request, "data" + action + "_childField");
            this.parentField = ParseUtil.getParameter(request, "data" + action + "_parentField");
        }
        if ((destPos = ParseUtil.getParameter(request, "data" + action + "_destPos")) != null) {
            this.position = destPos;
        } else {
            String keyToDestPos = ParseUtil.getParameter(request, "data" + action + "_keyToDestPos");
            if (keyToDestPos != null) {
                this.position = ParseUtil.getParameter(request, keyToDestPos);
            } else {
                String keyToKeyToDestPos = ParseUtil.getParameter(request, "data" + action + "_keyToKeyToDestPos");
                if (keyToKeyToDestPos != null) {
                    String widgetValue = ParseUtil.getParameter(request, keyToKeyToDestPos);
                    this.position = ParseUtil.getParameter(request, "k_" + widgetValue);
                }
            }
        }
        logCat.info((Object)("--->pos=" + this.position));
    }

    public GotoEvent(Table table, HttpServletRequest request, DbFormsConfig config, String position) {
        super(table, request, config);
        this.position = position;
    }

    public GotoEvent(Table table, HttpServletRequest request, DbFormsConfig config, String whereClause, String tableList) {
        super(table, request, config);
        this.whereClause = whereClause;
        this.tableList = tableList;
    }

    public ResultSetVector processEvent(FieldValue[] childFieldValues, FieldValue[] orderConstraint, String sqlFilter, FieldValue[] sqlFilterParams, int count, String firstPosition, String lastPosition, DbEventInterceptorData interceptorData) throws SQLException {
        if (Util.isNull(this.whereClause)) {
            int compMode;
            try {
                this.position = Util.decode(this.position, this.getRequest().getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                logCat.error((Object)e);
                throw new SQLException(e.getMessage());
            }
            int n = compMode = !Util.isNull(this.position) ? 1 : 0;
            if (!(Util.isNull(this.position) || this.srcTable == null || Util.isNull(this.childField) || Util.isNull(this.parentField))) {
                FieldValues fv = this.getTable().mapChildFieldValues(this.srcTable, this.parentField, this.childField, this.position);
                if (fv != null) {
                    childFieldValues = fv.toArray();
                    compMode = 0;
                }
            } else if (!Util.isNull(this.position)) {
                this.getTable().fillWithValues(orderConstraint, this.position);
            }
            logCat.info((Object)("gotopos = " + this.position));
            return this.getTable().doConstrainedSelect(childFieldValues, orderConstraint, sqlFilter, sqlFilterParams, compMode, count, interceptorData);
        }
        return this.getTable().doFreeFormSelect(this.whereClause, this.tableList, count, interceptorData);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

