/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.devgui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.dbforms.devgui.DevGui;
import org.dbforms.devgui.EditorPanel;
import org.dbforms.devgui.FileNameTool;
import org.dbforms.devgui.ProjectData;
import org.dbforms.devgui.PropertyPanel;
import org.dbforms.devgui.XMLConfigGenerator;

public class ConfigFilePanel
extends PropertyPanel
implements ActionListener {
    private ButtonGroup catalogButtonGroup;
    private ButtonGroup forkeyButtonGroup;
    private ButtonGroup schemaButtonGroup;
    private ButtonGroup tableButtonGroup;
    private DevGui parent;
    private EditorPanel panel_editor;
    private JButton b_browse;
    private JButton b_generate;
    private JButton b_loadLists;
    private JCheckBox cb_autocommit;
    private JCheckBox cb_examine_systabs;
    private JCheckBox cb_examine_tables;
    private JCheckBox cb_examine_views;
    private JCheckBox cb_include_catalogname;
    private JCheckBox cb_include_schemaname;
    private JCheckBox cb_stdTypeNames;
    private JComboBox catalogList;
    private JComboBox dateFormat;
    private JComboBox schemaList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel panel_top;
    private JRadioButton rb_catalog_all;
    private JRadioButton rb_catalog_combobox;
    private JRadioButton rb_forkey_deactivated;
    private JRadioButton rb_forkey_getCrossReferences;
    private JRadioButton rb_forkey_getImportedKeys;
    private JRadioButton rb_schema_all;
    private JRadioButton rb_schema_combobox;
    private JRadioButton rb_table_all;
    private JRadioButton rb_table_textfield;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JSeparator jSeparator8;
    private JTextField tf_configFile;
    private JTextField tf_tableNamePattern;
    private String[] dateFormats = new String[]{"", "yyyy-MM-dd", "yyyy_MM_dd", "yyyy/MM/dd", "yyyy.MM.dd", "dd-MMM-yyyy", "dd.MM.yyyy", "dd/MM/yyyyy", "MM-dd-yyyy"};

    public ConfigFilePanel(DevGui parent) {
        super(parent.getProjectData());
        this.parent = parent;
        this.initComponents();
        this.initComponents2();
        this.doLayout();
    }

    public void setNewProjectData(ProjectData projectData) {
        this.projectData = projectData;
        String webAppRoot = projectData.getProperty("webAppRoot");
        String configFile = projectData.getProperty("configFile");
        this.tf_configFile.setText("");
        if (!"".equals(configFile)) {
            this.tf_configFile.setText(configFile);
            File f = new File(configFile);
            if (f.exists() && f.isFile()) {
                this.panel_editor.setFile(f);
            }
        } else if (!"".equals(webAppRoot)) {
            this.tf_configFile.setText(FileNameTool.normalize(webAppRoot) + "WEB-INF" + this.parent.getFileSeparator());
        }
        this.initializeCatalogAndSchemaList();
        String forKeyDetection = projectData.getProperty("foreignKeyDetection");
        if ("deactivated".equalsIgnoreCase(forKeyDetection)) {
            this.rb_forkey_deactivated.setSelected(true);
        } else if ("useGetCrossReferences".equalsIgnoreCase(forKeyDetection)) {
            this.rb_forkey_getCrossReferences.setSelected(true);
        } else {
            this.rb_forkey_getImportedKeys.setSelected(true);
        }
        if ("all".equalsIgnoreCase(projectData.getProperty("catalogSelection"))) {
            this.rb_catalog_all.setSelected(true);
        } else {
            this.rb_catalog_combobox.setSelected(true);
        }
        if ("all".equalsIgnoreCase(projectData.getProperty("schemaSelection"))) {
            this.rb_schema_all.setSelected(true);
        } else {
            this.rb_schema_combobox.setSelected(true);
        }
        if ("all".equalsIgnoreCase(projectData.getProperty("tableSelection"))) {
            this.rb_table_all.setSelected(true);
        } else {
            this.rb_table_textfield.setSelected(true);
        }
        this.cb_include_catalogname.setSelected("true".equalsIgnoreCase(projectData.getProperty("includeCatalogName")));
        this.cb_include_schemaname.setSelected("true".equalsIgnoreCase(projectData.getProperty("includeSchemaName")));
        this.cb_autocommit.setSelected("true".equalsIgnoreCase(projectData.getProperty("autoCommitMode")));
        this.cb_stdTypeNames.setSelected("true".equalsIgnoreCase(projectData.getProperty("writeStdTypeNames")));
        this.cb_examine_tables.setSelected("true".equalsIgnoreCase(projectData.getProperty("examineTables")));
        this.cb_examine_views.setSelected("true".equalsIgnoreCase(projectData.getProperty("examineViews")));
        this.cb_examine_systabs.setSelected("true".equalsIgnoreCase(projectData.getProperty("examineSysTabs")));
        this.catalogList.setSelectedItem(projectData.getProperty("catalog"));
        this.schemaList.setSelectedItem(projectData.getProperty("schema"));
        this.tf_tableNamePattern.setText(projectData.getProperty("tableNamePattern"));
        if (projectData.getProperty("dateFormat") != null) {
            this.dateFormat.setSelectedItem(projectData.getProperty("dateFormat"));
        }
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() == this.b_generate) {
            String configFile = this.projectData.getProperty("configFile");
            if (!"".equals(configFile)) {
                File f = new File(configFile);
                try {
                    int read;
                    String result = XMLConfigGenerator.createXMLOutput(this.projectData, true);
                    FileOutputStream os = new FileOutputStream(f);
                    ByteArrayInputStream is = new ByteArrayInputStream(result.getBytes());
                    byte[] b = new byte[1024];
                    while ((read = is.read(b)) != -1) {
                        os.write(b, 0, read);
                    }
                    this.panel_editor.setFile(f);
                }
                catch (IOException ioe) {
                    this.showExceptionDialog(ioe);
                }
                catch (Exception e) {
                    this.showExceptionDialog(e);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Please enter name of config file");
            }
        } else if (ev.getSource() == this.b_browse) {
            File dlgFile;
            String configFile = this.projectData.getProperty("configFile");
            System.out.println("configFile=" + configFile + "!");
            System.out.println("ps2");
            if (!"".equals(configFile)) {
                System.out.println("ps3");
                dlgFile = new File(configFile);
                System.out.println("ps4");
            } else {
                System.out.println("ps5");
                String webAppRoot = this.projectData.getProperty("webAppRoot");
                System.out.println("ps6");
                if (!"".equals(webAppRoot)) {
                    System.out.println("ps7");
                    dlgFile = new File(webAppRoot);
                    System.out.println("ps8");
                } else {
                    System.out.println("ps9");
                    dlgFile = null;
                    System.out.println("ps10");
                }
            }
            if (dlgFile != null && dlgFile.exists()) {
                dlgFile = null;
            }
            JFileChooser dlg_fileChooser = new JFileChooser(dlgFile);
            dlg_fileChooser.setVisible(true);
            int returnVal = dlg_fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File selectedFile = dlg_fileChooser.getSelectedFile();
                this.tf_configFile.setText(selectedFile.getAbsolutePath());
                this.tf_configFile.grabFocus();
                this.panel_editor.setFile(selectedFile);
            }
        }
    }

    protected void addCheckBoxItemListener(final JCheckBox cb, final String propertyName) {
        cb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ConfigFilePanel.this.projectData.setProperty(propertyName, cb.isSelected() ? "true" : "false");
            }
        });
    }

    protected void addComboBoxItemListener(final JComboBox cb, final String p) {
        cb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ConfigFilePanel.this.projectData.setProperty(p, (String)cb.getSelectedItem());
            }
        });
    }

    protected void addJRadioButtonActionListener(JRadioButton rb, final String propertyName, final String propertyValue) {
        rb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigFilePanel.this.projectData.setProperty(propertyName, propertyValue);
            }
        });
    }

    private void initComponents() {
        this.catalogButtonGroup = new ButtonGroup();
        this.schemaButtonGroup = new ButtonGroup();
        this.tableButtonGroup = new ButtonGroup();
        this.forkeyButtonGroup = new ButtonGroup();
        this.panel_top = new JPanel();
        this.tf_tableNamePattern = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.tf_configFile = new JTextField();
        this.b_browse = new JButton();
        this.rb_catalog_all = new JRadioButton();
        this.rb_schema_all = new JRadioButton();
        this.rb_table_all = new JRadioButton();
        this.rb_table_textfield = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.rb_catalog_combobox = new JRadioButton();
        this.jPanel1 = new JPanel();
        this.b_generate = new JButton();
        this.rb_schema_combobox = new JRadioButton();
        this.cb_autocommit = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.cb_include_catalogname = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.cb_include_schemaname = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.jPanel4 = new JPanel();
        this.jLabel6 = new JLabel();
        this.cb_examine_tables = new JCheckBox();
        this.cb_examine_views = new JCheckBox();
        this.cb_examine_systabs = new JCheckBox();
        this.jSeparator5 = new JSeparator();
        this.catalogList = new JComboBox();
        this.schemaList = new JComboBox();
        this.b_loadLists = new JButton();
        this.cb_stdTypeNames = new JCheckBox();
        this.jSeparator6 = new JSeparator();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.dateFormat = new JComboBox();
        this.jSeparator7 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jLabel7 = new JLabel();
        this.rb_forkey_getImportedKeys = new JRadioButton();
        this.rb_forkey_getCrossReferences = new JRadioButton();
        this.rb_forkey_deactivated = new JRadioButton();
        this.jSeparator8 = new JSeparator();
        this.setLayout(new BorderLayout());
        this.panel_top.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panel_top.add((Component)this.tf_tableNamePattern, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("DbForms-Config File:   ");
        this.jPanel2.add((Component)this.jLabel1, new GridBagConstraints());
        this.tf_configFile.setMinimumSize(new Dimension(50, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.tf_configFile, gridBagConstraints);
        this.b_browse.setText("browse...");
        this.jPanel2.add((Component)this.b_browse, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panel_top.add((Component)this.jPanel2, gridBagConstraints);
        this.rb_catalog_all.setSelected(true);
        this.rb_catalog_all.setText("in all catalogs");
        this.catalogButtonGroup.add(this.rb_catalog_all);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.rb_catalog_all, gridBagConstraints);
        this.rb_schema_all.setSelected(true);
        this.rb_schema_all.setText("in all schemas");
        this.schemaButtonGroup.add(this.rb_schema_all);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.rb_schema_all, gridBagConstraints);
        this.rb_table_all.setSelected(true);
        this.rb_table_all.setText("with arbitrary names");
        this.tableButtonGroup.add(this.rb_table_all);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.rb_table_all, gridBagConstraints);
        this.rb_table_textfield.setText("with table name pattern:");
        this.tableButtonGroup.add(this.rb_table_textfield);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.rb_table_textfield, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.panel_top.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.panel_top.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.panel_top.add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.panel_top.add((Component)this.jSeparator4, gridBagConstraints);
        this.rb_catalog_combobox.setText("in catalog with name:");
        this.catalogButtonGroup.add(this.rb_catalog_combobox);
        this.rb_catalog_combobox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigFilePanel.this.rb_catalog_comboboxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.rb_catalog_combobox, gridBagConstraints);
        this.b_generate.setText("Generate XML!");
        this.jPanel1.add(this.b_generate);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 4;
        this.panel_top.add((Component)this.jPanel1, gridBagConstraints);
        this.rb_schema_combobox.setText("in schema with name pattern:");
        this.schemaButtonGroup.add(this.rb_schema_combobox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.rb_schema_combobox, gridBagConstraints);
        this.cb_autocommit.setSelected(true);
        this.cb_autocommit.setText("Use autocommit mode while reading metadata (recommended).");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.cb_autocommit, gridBagConstraints);
        this.jLabel3.setText("Include");
        this.jPanel3.add(this.jLabel3);
        this.cb_include_catalogname.setText("catalog name");
        this.jPanel3.add(this.cb_include_catalogname);
        this.jLabel4.setText(" ");
        this.jPanel3.add(this.jLabel4);
        this.cb_include_schemaname.setText("schema name");
        this.jPanel3.add(this.cb_include_schemaname);
        this.jLabel5.setText("in table name.");
        this.jPanel3.add(this.jLabel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jLabel6.setText("Examine");
        this.jPanel4.add(this.jLabel6);
        this.cb_examine_tables.setSelected(true);
        this.cb_examine_tables.setText("Tables");
        this.jPanel4.add(this.cb_examine_tables);
        this.cb_examine_views.setSelected(true);
        this.cb_examine_views.setText("Views");
        this.jPanel4.add(this.cb_examine_views);
        this.cb_examine_systabs.setText("System Tables");
        this.jPanel4.add(this.cb_examine_systabs);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.panel_top.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.jSeparator5, gridBagConstraints);
        this.catalogList.setEditable(true);
        this.catalogList.setMinimumSize(new Dimension(124, 24));
        this.catalogList.setPreferredSize(new Dimension(128, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panel_top.add((Component)this.catalogList, gridBagConstraints);
        this.schemaList.setEditable(true);
        this.schemaList.setMinimumSize(new Dimension(124, 24));
        this.schemaList.setPreferredSize(new Dimension(128, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panel_top.add((Component)this.schemaList, gridBagConstraints);
        this.b_loadLists.setText("Load");
        this.b_loadLists.setToolTipText("Load catalog and schema names from database");
        this.b_loadLists.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigFilePanel.this.loadCatalogAndSchemaNames(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.5;
        this.panel_top.add((Component)this.b_loadLists, gridBagConstraints);
        this.cb_stdTypeNames.setText("Try to write standard type names for unknown field types into xml config file.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.cb_stdTypeNames, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panel_top.add((Component)this.jSeparator6, gridBagConstraints);
        this.jLabel2.setText("Set date format to: ");
        this.jPanel5.add(this.jLabel2);
        this.dateFormat.setEditable(true);
        this.jPanel5.add(this.dateFormat);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.panel_top.add((Component)this.jSeparator7, gridBagConstraints);
        this.jPanel6.setLayout(new FlowLayout(0));
        this.jLabel7.setText("Foreign Key Detection:");
        this.jPanel6.add(this.jLabel7);
        this.rb_forkey_getImportedKeys.setSelected(true);
        this.rb_forkey_getImportedKeys.setText("getImportedKeys( )");
        this.forkeyButtonGroup.add(this.rb_forkey_getImportedKeys);
        this.jPanel6.add(this.rb_forkey_getImportedKeys);
        this.rb_forkey_getCrossReferences.setText("getCrossReferences( )");
        this.rb_forkey_getCrossReferences.setToolTipText("null");
        this.forkeyButtonGroup.add(this.rb_forkey_getCrossReferences);
        this.jPanel6.add(this.rb_forkey_getCrossReferences);
        this.rb_forkey_deactivated.setText("deactivated");
        this.forkeyButtonGroup.add(this.rb_forkey_deactivated);
        this.jPanel6.add(this.rb_forkey_deactivated);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        gridBagConstraints.anchor = 17;
        this.panel_top.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panel_top.add((Component)this.jSeparator8, gridBagConstraints);
        this.add((Component)this.panel_top, "North");
    }

    private void initComponents2() {
        this.b_browse.addActionListener(this);
        this.addAFocusListener(this.tf_configFile, "configFile");
        this.tf_configFile.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                File f = new File(ConfigFilePanel.this.tf_configFile.getText());
                if (f.exists() && f.isFile() && f.canRead()) {
                    ConfigFilePanel.this.panel_editor.setFile(f);
                }
            }
        });
        this.b_browse.setToolTipText("default: webAppRoot" + this.parent.getFileSeparator() + "WEB-INF" + this.parent.getFileSeparator() + "dbforms-config.xml\nNon-default values must be configured in web.xml!");
        this.b_generate.addActionListener(this);
        this.b_generate.setToolTipText("Generate raw content of config-file by quering the database you defined in tab \"Database properties\".");
        this.panel_editor = new EditorPanel();
        this.add("Center", this.panel_editor);
        this.addAFocusListener(this.tf_tableNamePattern, "tableNamePattern");
        this.addJRadioButtonActionListener(this.rb_catalog_all, "catalogSelection", "all");
        this.addJRadioButtonActionListener(this.rb_catalog_combobox, "catalogSelection", "selection");
        this.addJRadioButtonActionListener(this.rb_schema_all, "schemaSelection", "all");
        this.addJRadioButtonActionListener(this.rb_schema_combobox, "schemaSelection", "selection");
        this.addJRadioButtonActionListener(this.rb_table_all, "tableSelection", "all");
        this.addJRadioButtonActionListener(this.rb_table_textfield, "tableSelection", "selection");
        this.addJRadioButtonActionListener(this.rb_forkey_getImportedKeys, "foreignKeyDetection", "useGetImportedKeys");
        this.addJRadioButtonActionListener(this.rb_forkey_getCrossReferences, "foreignKeyDetection", "useGetCrossReferences");
        this.addJRadioButtonActionListener(this.rb_forkey_deactivated, "foreignKeyDetection", "deactivated");
        this.addCheckBoxItemListener(this.cb_include_catalogname, "includeCatalogName");
        this.addCheckBoxItemListener(this.cb_include_schemaname, "includeSchemaName");
        this.addCheckBoxItemListener(this.cb_autocommit, "autoCommitMode");
        this.addCheckBoxItemListener(this.cb_examine_tables, "examineTables");
        this.addCheckBoxItemListener(this.cb_examine_views, "examineViews");
        this.addCheckBoxItemListener(this.cb_examine_systabs, "examineSysTabs");
        this.addCheckBoxItemListener(this.cb_stdTypeNames, "writeStdTypeNames");
        this.initializeCatalogAndSchemaList();
        this.addComboBoxItemListener(this.catalogList, "catalog");
        this.addComboBoxItemListener(this.schemaList, "schema");
        for (int i = 0; i < this.dateFormats.length; ++i) {
            this.dateFormat.addItem(this.dateFormats[i]);
        }
        this.addComboBoxItemListener(this.dateFormat, "dateFormat");
    }

    private void initializeCatalogAndSchemaList() {
        Vector<String> catalogs = new Vector<String>();
        catalogs.add("--- no catalogs loaded ---");
        this.catalogList.setModel(new DefaultComboBoxModel(catalogs));
        Vector<String> schemas = new Vector<String>();
        schemas.add("--- no schemas loaded ---");
        this.schemaList.setModel(new DefaultComboBoxModel(schemas));
    }

    private void loadCatalogAndSchemaNames(ActionEvent evt) {
        String jdbcDriver = this.projectData.getProperty("jdbcDriver");
        String jdbcURL = this.projectData.getProperty("jdbcURL");
        String username = this.projectData.getProperty("username");
        String password = this.projectData.getProperty("password");
        try {
            try {
                Class.forName(jdbcDriver).newInstance();
            }
            catch (ClassNotFoundException ex) {
                String message = "Could not find JDBC driver class " + jdbcDriver + "\n" + "Please check database properties and classpath!";
                if (jdbcDriver.equalsIgnoreCase("")) {
                    message = "JDBC driver class in database properties not set!\nPlease check database properties!";
                }
                JOptionPane.showMessageDialog(this, message);
                return;
            }
            Connection con = DriverManager.getConnection(jdbcURL, username, password);
            DatabaseMetaData dbmd = con.getMetaData();
            Vector<String> catalogs = new Vector<String>();
            try {
                ResultSet catalogRs = dbmd.getCatalogs();
                while (catalogRs.next()) {
                    catalogs.add(catalogRs.getString(1));
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            if (catalogs.size() == 0) {
                catalogs.add(" --- no catalogs found ---");
            }
            this.catalogList.setModel(new DefaultComboBoxModel(catalogs));
            this.catalogList.setSelectedIndex(0);
            this.projectData.setProperty("catalog", (String)this.catalogList.getItemAt(0));
            Vector<String> schemas = new Vector<String>();
            ResultSet schemaRs = dbmd.getSchemas();
            while (schemaRs.next()) {
                schemas.add(schemaRs.getString(1));
            }
            if (schemas.size() == 0) {
                schemas.add("--- no schemas found ---");
            }
            this.schemaList.setModel(new DefaultComboBoxModel(schemas));
            this.schemaList.setSelectedIndex(0);
            this.projectData.setProperty("schema", (String)this.schemaList.getItemAt(0));
        }
        catch (Exception ex) {
            this.showExceptionDialog(ex);
        }
    }

    private void rb_catalog_comboboxActionPerformed(ActionEvent evt) {
    }
}

