/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import javax.servlet.ServletContext;
import org.dbforms.config.DbFormsConfig;

public class DbFormsConfigRegistry {
    private static DbFormsConfigRegistry instance = null;
    private ServletContext servletContext = null;

    protected DbFormsConfigRegistry() {
    }

    public static synchronized DbFormsConfigRegistry instance() {
        if (instance == null) {
            instance = new DbFormsConfigRegistry();
        }
        return instance;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public DbFormsConfig lookup() throws Exception {
        return this.lookup("dbformsConfig");
    }

    public void register(DbFormsConfig config) {
        this.register("dbformsConfig", config);
    }

    private DbFormsConfig lookup(String name) throws Exception {
        DbFormsConfig config = null;
        if (this.servletContext == null) {
            throw new Exception("cannot lookup a config object with the name [" + name + "]");
        }
        config = (DbFormsConfig)this.servletContext.getAttribute(name);
        return config;
    }

    private void register(String name, DbFormsConfig config) {
        if (this.servletContext != null) {
            this.servletContext.setAttribute(name, (Object)config);
        }
    }
}

