/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.resource;

import de.destatis.core.resource.Resource;
import de.destatis.core.resource.ResourceException;
import de.destatis.core.resource.SurveyResource;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.parser.SDFParser;
import java.io.IOException;
import java.io.Reader;

public class DatmlSdfSource
extends Resource
implements SurveyResource {
    private MetaErhebungsbeschreibung erhebungsbeschreibung;

    public DatmlSdfSource(String resourceId, byte[] resourceData) {
        super(resourceId, resourceData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetaErhebungsbeschreibung getErhebungsbeschreibung() throws ResourceException {
        if (this.erhebungsbeschreibung == null) {
            Reader reader = null;
            try {
                reader = this.getReader();
                SDFParser parser = new SDFParser();
                parser.setCheckNamespace(false);
                parser.setSDFGlobalNamespace(true);
                try {
                    MetaErhebungsbeschreibung tmpErhebungsbeschreibung = parser.parse(reader);
                    String erhebungsbeschreibungResourceId = "1" + tmpErhebungsbeschreibung.getProzedurCode();
                    String resourceResourceId = this.getResourceId();
                    if (erhebungsbeschreibungResourceId == null || !erhebungsbeschreibungResourceId.equals(resourceResourceId)) {
                        throw new ResourceException("Inkonsistente Ressource! Die RessourceID '" + erhebungsbeschreibungResourceId + "' der Erhebungsbeschreibung passt nicht zur RessourceID '" + resourceResourceId + "' der Ressource.");
                    }
                    this.erhebungsbeschreibung = tmpErhebungsbeschreibung;
                }
                catch (Exception e) {
                    throw new ResourceException(e);
                }
                try {
                    reader.close();
                    reader = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return this.erhebungsbeschreibung;
    }

    @Override
    protected String getEncoding() {
        return "ISO-8859-1";
    }
}

