/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.util;

import de.destatis.core.map.FieldBinding;
import de.destatis.core.map.editor.util.AbstractTableCreator;
import java.io.BufferedWriter;
import java.io.IOException;

public abstract class CsvTableCreator
extends AbstractTableCreator {
    protected String encoding;
    protected char csvSeparator;
    protected char csvQuote;

    protected CsvTableCreator(String encoding, char csvSeparator, char csvQuote) {
        this.encoding = encoding;
        this.csvSeparator = csvSeparator;
        this.csvQuote = csvQuote;
    }

    @Override
    protected Object createRecordValue(FieldBinding fieldBinding, int offset, String currentStructure) {
        return currentStructure != null && currentStructure.length() > 0 ? currentStructure + fieldBinding.getId() : fieldBinding.getId();
    }

    protected void writeCsvRecord(BufferedWriter writer, Object[] csvRecord) throws IOException {
        int len = csvRecord.length;
        for (int i = 0; i < len; ++i) {
            Object objValue;
            String value;
            if (i > 0) {
                writer.write(this.csvSeparator);
            }
            String string = value = (objValue = csvRecord[i]) != null ? objValue.toString() : null;
            if (value == null) continue;
            writer.write(this.csvQuote);
            if (value.indexOf(this.csvQuote) != -1) {
                for (char character : value.toCharArray()) {
                    if (character == this.csvQuote) {
                        writer.write(this.csvQuote);
                    }
                    writer.write(character);
                }
            } else {
                writer.write(value);
            }
            writer.write(this.csvQuote);
        }
    }
}

