/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor;

import de.destatis.core.map.Mapping;
import de.destatis.core.map.MappingCheck;
import de.destatis.core.map.MappingCheckResult;
import de.destatis.core.map.MappingGenerator;
import de.destatis.core.map.editor.MappingEditorTool;
import de.destatis.core.map.editor.MappingTreeTableModel;
import de.destatis.core.map.editor.PropertiesIfc;
import de.destatis.core.map.editor.SDFMappingTreeTableModel;
import de.destatis.core.map.editor.UndoSupport;
import de.destatis.core.map.editor.util.BindedElementProvider;
import de.destatis.core.map.editor.util.MappingHtmlPreviewCreator;
import de.destatis.core.map.editor.util.SDFBindedElementProvider;
import de.destatis.core.map.model.BindingHelper;
import de.destatis.core.map.model.HelpFeatureConfigValue;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SDFMappingEditorTool
extends MappingEditorTool {
    private Mapping mapping;
    private MetaErhebungsbeschreibung surveyDefinition;
    private boolean withCustomName;
    private JTextField customName;
    private JComboBox helpFeatureConfig;
    private DocumentListener documentListener;
    private ActionListener helpFeatureListener;

    public SDFMappingEditorTool(UndoSupport undoSupport, boolean dirtyFlag, PropertiesIfc properties, Mapping mapping, MetaErhebungsbeschreibung surveyDefinition, boolean withCustomName) {
        super(undoSupport, dirtyFlag, properties);
        this.mapping = mapping;
        this.surveyDefinition = surveyDefinition;
        this.withCustomName = withCustomName;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public void setMapping(Mapping mapping) {
        if (this.activated()) {
            throw new IllegalStateException("Das Werkzeug wurde bereits aktiviert.");
        }
        this.mapping = mapping;
    }

    public void setErhebungsbeschreibung(MetaErhebungsbeschreibung surveyDefinition) {
        if (this.activated()) {
            throw new IllegalStateException("Das Werkzeug wurde bereits aktiviert.");
        }
        this.surveyDefinition = surveyDefinition;
    }

    public MetaErhebungsbeschreibung getErhebungsbeschreibung() {
        return this.surveyDefinition;
    }

    @Override
    protected void doActivate() {
        if (this.customName != null) {
            this.customName.setText(this.mapping.getCustomName());
        }
        this.helpFeatureConfig.setSelectedItem(this.mapping.getHelpFeatureConfig());
        this.helpFeatureListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpFeatureConfigValue newValue = (HelpFeatureConfigValue)SDFMappingEditorTool.this.helpFeatureConfig.getSelectedItem();
                SDFMappingEditorTool.this.changeHelpFeatureConfig(newValue);
            }
        };
        this.helpFeatureConfig.addActionListener(this.helpFeatureListener);
        this.documentListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent paramDocumentEvent) {
                SDFMappingEditorTool.this.setDirtyFlag(true);
            }

            @Override
            public void insertUpdate(DocumentEvent paramDocumentEvent) {
                SDFMappingEditorTool.this.setDirtyFlag(true);
            }

            @Override
            public void changedUpdate(DocumentEvent paramDocumentEvent) {
            }
        };
        if (this.customName != null) {
            this.customName.getDocument().addDocumentListener(this.documentListener);
        }
    }

    @Override
    protected MappingCheckResult doCheck() {
        MappingCheck mappingCheck = new MappingCheck();
        MappingCheckResult result = mappingCheck.check(this.mapping, this.surveyDefinition);
        return result;
    }

    @Override
    protected MappingTreeTableModel createTreeTableModel() {
        return new SDFMappingTreeTableModel(this, this.mapping, this.undoSupport != null ? this.undoSupport.getUndoableEditSupport() : null);
    }

    @Override
    protected JComponent createLeftGUI() {
        JScrollPane scrollPane = new JScrollPane(this.treeTable);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getViewport().setBackground(this.treeTable.getBackground());
        JPanel mappingDetailPanel = new JPanel(new GridBagLayout());
        mappingDetailPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlShadow), BorderFactory.createEmptyBorder(8, 8, 10, 8)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        if (this.withCustomName) {
            mappingDetailPanel.add((Component)new JLabel("Name:"), gbc);
            ++gbc.gridy;
            gbc.insets.top = 5;
        }
        mappingDetailPanel.add((Component)new JLabel("Hilfsmerkmale:"), gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.left = 5;
        gbc.insets.top = 0;
        if (this.withCustomName) {
            this.customName = new JTextField();
            mappingDetailPanel.add((Component)this.customName, gbc);
            ++gbc.gridy;
            gbc.insets.top = 5;
        }
        this.helpFeatureConfig = new JComboBox<HelpFeatureConfigValue>(HelpFeatureConfigValue.getAllValues());
        mappingDetailPanel.add((Component)this.helpFeatureConfig, gbc);
        JPanel dataPanel = new JPanel(new BorderLayout());
        dataPanel.add((Component)mappingDetailPanel, "North");
        dataPanel.add((Component)scrollPane, "Center");
        return dataPanel;
    }

    @Override
    public boolean commitChangesToMapping() {
        boolean ok = super.commitChangesToMapping();
        if (this.customName != null) {
            this.mapping.setCustomName(this.customName.getText());
        }
        return ok;
    }

    @Override
    protected void doSave(OutputStream out) throws IOException {
        MappingGenerator generator = new MappingGenerator();
        generator.generate(this.mapping, out);
        out.close();
    }

    @Override
    public void close() {
        super.close();
        if (this.customName != null && this.documentListener != null) {
            this.customName.getDocument().removeDocumentListener(this.documentListener);
        }
        if (this.helpFeatureConfig != null && this.helpFeatureListener != null) {
            this.helpFeatureConfig.removeActionListener(this.helpFeatureListener);
        }
    }

    @Override
    protected JPopupMenu createTablePopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(this.getExpandAction());
        popupMenu.add(this.getCollapseAction());
        popupMenu.add(new JSeparator(0));
        popupMenu.add(this.getExpandAllAction());
        popupMenu.add(this.getCollapseAllAction());
        popupMenu.add(new JSeparator(0));
        popupMenu.add(this.getComputeStandardPositionsAction());
        popupMenu.add(this.getShowTablePreviewAction());
        return popupMenu;
    }

    @Override
    protected String getTablePreview() {
        StringWriter writer = new StringWriter();
        MappingHtmlPreviewCreator creator = new MappingHtmlPreviewCreator(writer, this.mapping);
        creator.run();
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    @Override
    protected void computeStandardPositions() {
        int rc = JOptionPane.showConfirmDialog(this.getGUI(), "Die Feldpositionen werden neu berechnet.\nHierbei werden die aktuellen Positionsangaben \u00fcberschrieben!\nSollen die Feldpositionen jetzt neu berechnet werden?", "Standardpositionen neu berechnen?", 0, 3);
        if (rc == 0) {
            BindingHelper.computePositions(this.mapping);
            if (this.undoSupport != null) {
                this.undoSupport.clearUndoStacks();
            }
            this.treeTable.repaint();
            this.setDirtyFlag(true);
            this.updateInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeHelpFeatureConfig(HelpFeatureConfigValue newValue) {
        HelpFeatureConfigValue currentValue = this.mapping.getHelpFeatureConfig();
        if (!newValue.equals(currentValue)) {
            boolean cancel = false;
            int rc = JOptionPane.showConfirmDialog(this.getGUI(), "Die Feldpositionen m\u00fcssen neu berechnet werden.\nKlicken Sie auf \"Ja\", um die Feldpositionen neu zu berechnen, und die aktuellen Positionsangaben zu \u00fcberschreiben.\nKlicken Sie auf \"Nein\", um die aktuellen Feldpositionen beizubehalten.\nKlicken Sie auf \"Abbrechen\", um den Vorgang abzubrechen.\n", "Positionen neu berechnen?", 1, 3);
            if (rc == 0) {
                this.mapping.setHelpFeatureConfig(newValue);
                BindingHelper.computePositions(this.mapping);
            } else if (rc == 1) {
                this.mapping.setHelpFeatureConfig(newValue);
                if (newValue.isDefaultValue()) {
                    BindingHelper.clearHelpFeaturePositions(this.mapping);
                }
            } else {
                cancel = true;
            }
            if (!cancel) {
                if (this.undoSupport != null) {
                    this.undoSupport.clearUndoStacks();
                }
                this.treeTable.repaint();
                this.setDirtyFlag(true);
            } else {
                this.helpFeatureConfig.removeActionListener(this.helpFeatureListener);
                try {
                    this.helpFeatureConfig.setSelectedItem(currentValue);
                }
                finally {
                    this.helpFeatureConfig.addActionListener(this.helpFeatureListener);
                }
            }
        }
    }

    @Override
    protected BindedElementProvider createBindedElementProvider() {
        return new SDFBindedElementProvider(this.surveyDefinition);
    }

    static {
        UIManager.put("PopupMenu.consumeEventOnClose", Boolean.FALSE);
    }
}

